# This script was automatically generated from the dsa-1423
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in sitebar, a
web based bookmark manager written in PHP.  The Common Vulnerabilities and
Exposures project identifies the following problems:
   A directory traversal vulnerability in the translation module allows
   remote authenticated users to chmod arbitrary files to 0777 via <q>..</q>
   sequences in the <q>lang</q> parameter.
   A static code injection vulnerability in the translation module allows
   a remote authenticated user to execute arbitrary PHP code via the <q>value</q>
   parameter.
   An eval injection vulnerability in the translation module allows 
   remote authenticated users to execute arbitrary PHP code via the
   <q>edit</q> parameter in an <q>upd cmd</q> action.
   A path traversal vulnerability in the translation module allows 
   remote authenticated users to read arbitrary files via an absolute
   path in the <q>dir</q> parameter.
   An error in command.php allows remote attackers to redirect users
   to arbitrary web sites via the <q>forward</q> parameter in a <q>Log In</q> action.
   Multiple cross site scripting flaws allow remote attackers to inject
   arbitrary script or HTML fragments into several scripts.
For the old stable distribution (sarge), these problems have been fixed in
version 3.2.6-7.1sarge1.
For the stable distribution (etch), these problems have been fixed in version
3.3.8-7etch1.
For the unstable distribution (sid), these problems have been fixed in version
3.3.8-12.1.
We recommend that you upgrade your sitebar package.


Solution : http://www.debian.org/security/2007/dsa-1423
Risk factor : High';

if (description) {
 script_id(29258);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1423");
 script_cve_id("CVE-2007-5491", "CVE-2007-5492", "CVE-2007-5692", "CVE-2007-5693", "CVE-2007-5694", "CVE-2007-5695");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1423] DSA-1423-1 sitebar");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1423-1 sitebar");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'sitebar', release: '3.1', reference: '3.2.6-7.1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package sitebar is vulnerable in Debian 3.1.\nUpgrade to sitebar_3.2.6-7.1sarge1\n');
}
if (deb_check(prefix: 'sitebar', release: '4.0', reference: '3.3.8-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package sitebar is vulnerable in Debian 4.0.\nUpgrade to sitebar_3.3.8-7etch1\n');
}
if (deb_check(prefix: 'sitebar', release: '4.0', reference: '3.3.8-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package sitebar is vulnerable in Debian etch.\nUpgrade to sitebar_3.3.8-7etch1\n');
}
if (deb_check(prefix: 'sitebar', release: '3.1', reference: '3.2.6-7.1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package sitebar is vulnerable in Debian sarge.\nUpgrade to sitebar_3.2.6-7.1sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
