# This script was automatically generated from the dsa-1424
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Iceweasel web
browser, an unbranded version of the Firefox browser. The Common
Vulnerabilities and Exposures project identifies the following problems:
    Jesse Ruderman and Petko D. Petkov discovered that the URI handler
    for JAR archives allows cross-site scripting.
    Several crashes in the layout engine were discovered, which might
    allow the execution of arbitrary code.
    Gregory Fleischer discovered a race condition in the handling of
    the <q>window.location</q> property, which might lead to cross-site
    request forgery.
The Mozilla products in the oldstable distribution (sarge) are no longer
supported with security updates.
For the stable distribution (etch) these problems have been fixed in
version 2.0.0.10-0etch1.
For the unstable distribution (sid) these problems have been fixed in
version 2.0.0.10-2.
We recommend that you upgrade your iceweasel packages.


Solution : http://www.debian.org/security/2007/dsa-1424
Risk factor : High';

if (description) {
 script_id(29259);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1424");
 script_cve_id("CVE-2007-5947", "CVE-2007-5959", "CVE-2007-5960");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1424] DSA-1424-1 iceweasel");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1424-1 iceweasel");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'firefox', release: '4.0', reference: '2.0.0.10-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package firefox is vulnerable in Debian 4.0.\nUpgrade to firefox_2.0.0.10-0etch1\n');
}
if (deb_check(prefix: 'firefox-dom-inspector', release: '4.0', reference: '2.0.0.10-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package firefox-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to firefox-dom-inspector_2.0.0.10-0etch1\n');
}
if (deb_check(prefix: 'firefox-gnome-support', release: '4.0', reference: '2.0.0.10-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package firefox-gnome-support is vulnerable in Debian 4.0.\nUpgrade to firefox-gnome-support_2.0.0.10-0etch1\n');
}
if (deb_check(prefix: 'iceweasel', release: '4.0', reference: '2.0.0.10-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel is vulnerable in Debian 4.0.\nUpgrade to iceweasel_2.0.0.10-0etch1\n');
}
if (deb_check(prefix: 'iceweasel-dbg', release: '4.0', reference: '2.0.0.10-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel-dbg is vulnerable in Debian 4.0.\nUpgrade to iceweasel-dbg_2.0.0.10-0etch1\n');
}
if (deb_check(prefix: 'iceweasel-dom-inspector', release: '4.0', reference: '2.0.0.10-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to iceweasel-dom-inspector_2.0.0.10-0etch1\n');
}
if (deb_check(prefix: 'iceweasel-gnome-support', release: '4.0', reference: '2.0.0.10-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel-gnome-support is vulnerable in Debian 4.0.\nUpgrade to iceweasel-gnome-support_2.0.0.10-0etch1\n');
}
if (deb_check(prefix: 'mozilla-firefox', release: '4.0', reference: '2.0.0.10-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox is vulnerable in Debian 4.0.\nUpgrade to mozilla-firefox_2.0.0.10-0etch1\n');
}
if (deb_check(prefix: 'mozilla-firefox-dom-inspector', release: '4.0', reference: '2.0.0.10-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to mozilla-firefox-dom-inspector_2.0.0.10-0etch1\n');
}
if (deb_check(prefix: 'mozilla-firefox-gnome-support', release: '4.0', reference: '2.0.0.10-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-gnome-support is vulnerable in Debian 4.0.\nUpgrade to mozilla-firefox-gnome-support_2.0.0.10-0etch1\n');
}
if (deb_check(prefix: 'iceweasel', release: '4.0', reference: '2.0.0.10-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel is vulnerable in Debian etch.\nUpgrade to iceweasel_2.0.0.10-0etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
