# This script was automatically generated from the dsa-1429
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Michael Skibbe discovered that htdig, a WWW search system for an intranet
or small internet, did not adequately quote values submitted to the search
script, allowing remote attackers to inject arbitrary script or HTML
into specially crafted links.
For the old stable distribution (sarge), this problem was not present.
For the stable distribution (etch), this problem has been fixed in version
1:3.2.0b6-3.1etch1.
For the unstable distribution (sid), this problem has been fixed in version
1:3.2.0b6-4.
We recommend that you upgrade your htdig package.


Solution : http://www.debian.org/security/2007/dsa-1429
Risk factor : High';

if (description) {
 script_id(29337);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1429");
 script_cve_id("CVE-2007-6110");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1429] DSA-1429-1 htdig");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1429-1 htdig");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'htdig', release: '4.0', reference: '3.2.0b6-3.1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package htdig is vulnerable in Debian 4.0.\nUpgrade to htdig_3.2.0b6-3.1etch1\n');
}
if (deb_check(prefix: 'htdig-doc', release: '4.0', reference: '3.2.0b6-3.1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package htdig-doc is vulnerable in Debian 4.0.\nUpgrade to htdig-doc_3.2.0b6-3.1etch1\n');
}
if (deb_check(prefix: 'htdig', release: '4.0', reference: '3.2.0b6-3.1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package htdig is vulnerable in Debian etch.\nUpgrade to htdig_3.2.0b6-3.1etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
