# This script was automatically generated from the dsa-1430
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was reported that a race condition exists in libnss-ldap, an
NSS module for using LDAP as a naming service, which could cause
denial of service attacks if applications use pthreads.
This problem was spotted in the dovecot IMAP/POP server but
potentially affects more programs.
For the stable distribution (etch), this problem has been fixed in version
251-7.5etch1.
For the old stable distribution (sarge), this problem has been fixed in
version 238-1sarge1.
For the unstable distribution (sid), this problem has been fixed in
version 256-1.
We recommend that you upgrade your libnss-ldap package.


Solution : http://www.debian.org/security/2007/dsa-1430
Risk factor : High';

if (description) {
 script_id(29338);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1430");
 script_cve_id("CVE-2007-5794");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1430] DSA-1430-1 libnss-ldap");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1430-1 libnss-ldap");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libnss-ldap', release: '3.1', reference: '238-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnss-ldap is vulnerable in Debian 3.1.\nUpgrade to libnss-ldap_238-1sarge1\n');
}
if (deb_check(prefix: 'libnss-ldap', release: '4.0', reference: '251-7.5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnss-ldap is vulnerable in Debian 4.0.\nUpgrade to libnss-ldap_251-7.5etch1\n');
}
if (deb_check(prefix: 'libnss-ldap', release: '4.0', reference: '251-7.5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnss-ldap is vulnerable in Debian etch.\nUpgrade to libnss-ldap_251-7.5etch1\n');
}
if (deb_check(prefix: 'libnss-ldap', release: '3.1', reference: '238-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnss-ldap is vulnerable in Debian sarge.\nUpgrade to libnss-ldap_238-1sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
