# This script was automatically generated from the dsa-1440
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

It was discovered that a buffer overflow in the filename processing of
the inotify-tools, a command-line interface to inotify, may lead to
the execution of arbitrary code. This only affects the internal 
library and none of the frontend tools shipped in Debian.


The old stable distribution (sarge) does not provide inotify-tools.


For the stable distribution (etch), this problem has been fixed in
version 3.3-2.


For the unstable distribution (sid), this problem has been fixed in
version 3.11-1.


We recommend that you upgrade your inotify-tools package.



Solution : http://www.debian.org/security/2007/dsa-1440
Risk factor : High';

if (description) {
 script_id(29807);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1440");
 script_cve_id("CVE-2007-5037");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1440] DSA-1440-1 inotify-tools");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1440-1 inotify-tools");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'inotify-tools', release: '4.0', reference: '3.3-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package inotify-tools is vulnerable in Debian 4.0.\nUpgrade to inotify-tools_3.3-2\n');
}
if (deb_check(prefix: 'inotify-tools', release: '4.0', reference: '3.3-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package inotify-tools is vulnerable in Debian etch.\nUpgrade to inotify-tools_3.3-2\n');
}
if (w) { security_hole(port: 0, data: desc); }
