# This script was automatically generated from the dsa-1445
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Michael Krieger and Sam Trenholme discovered a programming error in
MaraDNS, a simple security-aware Domain Name Service server, which
might lead to denial of service through malformed DNS packets.


For the old stable distribution (sarge), this problem has been fixed
in version 1.0.27-2.


For the stable distribution (etch), this problem has been fixed in
version 1.2.12.04-1etch2.


For the unstable distribution (sid), this problem has been fixed in
version 1.2.12.08-1.


We recommend that you upgrade your maradns package.



Solution : http://www.debian.org/security/2008/dsa-1445
Risk factor : High';

if (description) {
 script_id(29839);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1445");
 script_cve_id("CVE-2008-0061");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1445] DSA-1445-1 maradns");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1445-1 maradns");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'maradns', release: '3.1', reference: '1.0.27-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package maradns is vulnerable in Debian 3.1.\nUpgrade to maradns_1.0.27-2\n');
}
if (deb_check(prefix: 'maradns', release: '4.0', reference: '1.2.12.04-1etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package maradns is vulnerable in Debian 4.0.\nUpgrade to maradns_1.2.12.04-1etch2\n');
}
if (deb_check(prefix: 'maradns', release: '4.0', reference: '1.2.12.04-1etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package maradns is vulnerable in Debian etch.\nUpgrade to maradns_1.2.12.04-1etch2\n');
}
if (deb_check(prefix: 'maradns', release: '3.1', reference: '1.0.27-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package maradns is vulnerable in Debian sarge.\nUpgrade to maradns_1.0.27-2\n');
}
if (w) { security_hole(port: 0, data: desc); }
