# This script was automatically generated from the dsa-1447
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Several remote vulnerabilities have been discovered in the Tomcat
servlet and JSP engine. The Common Vulnerabilities and Exposures project
identifies the following problems:

    
    It was discovered that single quotes (\') in cookies were treated
    as a delimiter, which could lead to an information leak.
    
    
    It was discovered that the character sequence \\" in cookies was
    handled incorrectly, which could lead to an information leak.
    
    
    It was discovered that the host manager servlet performed
    insufficient input validation, which could lead to a cross-site
    scripting attack.
    
    
    It was discovered that the JULI logging component did not restrict
    its target path, resulting in potential denial of service through
    file overwrites.
    
    
    It was discovered that the WebDAV servlet is vulnerable to absolute
    path traversal.
    

The old stable distribution (sarge) doesn\'t contain tomcat5.5.


For the stable distribution (etch), these problems have been fixed in
version 5.5.20-2etch1.


For the unstable distribution (sid) these problems will be fixed soon.


We recommend that you upgrade your tomcat5.5 packages.



Solution : http://www.debian.org/security/2008/dsa-1447
Risk factor : High';

if (description) {
 script_id(29856);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1447");
 script_cve_id("CVE-2007-3382", "CVE-2007-3385", "CVE-2007-3386", "CVE-2007-5342", "CVE-2007-5461");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1447] DSA-1447-1 tomcat5.5");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1447-1 tomcat5.5");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libtomcat5.5-java', release: '4.0', reference: '5.5.20-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libtomcat5.5-java is vulnerable in Debian 4.0.\nUpgrade to libtomcat5.5-java_5.5.20-2etch1\n');
}
if (deb_check(prefix: 'tomcat5.5', release: '4.0', reference: '5.5.20-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tomcat5.5 is vulnerable in Debian 4.0.\nUpgrade to tomcat5.5_5.5.20-2etch1\n');
}
if (deb_check(prefix: 'tomcat5.5-admin', release: '4.0', reference: '5.5.20-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tomcat5.5-admin is vulnerable in Debian 4.0.\nUpgrade to tomcat5.5-admin_5.5.20-2etch1\n');
}
if (deb_check(prefix: 'tomcat5.5-webapps', release: '4.0', reference: '5.5.20-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tomcat5.5-webapps is vulnerable in Debian 4.0.\nUpgrade to tomcat5.5-webapps_5.5.20-2etch1\n');
}
if (deb_check(prefix: 'tomcat5.5', release: '4.0', reference: '5.5.20-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tomcat5.5 is vulnerable in Debian etch.\nUpgrade to tomcat5.5_5.5.20-2etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
