# This script was automatically generated from the dsa-1450
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that util-linux, miscellaneous system utilities, 
didn\'t drop privileged user and group permissions in the correct order
in the mount and umount commands.  This could potentially allow a local
user to gain additional privileges.
For the old stable distribution (sarge), this problem has been fixed in
version 2.12p-4sarge2.
For the stable distribution (etch), this problem has been fixed in version
2.12r-19etch1.
We recommend that you upgrade your util-linux package.


Solution : http://www.debian.org/security/2008/dsa-1450
Risk factor : High';

if (description) {
 script_id(29859);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1450");
 script_cve_id("CVE-2007-5191");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1450] DSA-1450-1 util-linux");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1450-1 util-linux");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'bsdutils', release: '3.1', reference: '2.12p-4sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package bsdutils is vulnerable in Debian 3.1.\nUpgrade to bsdutils_2.12p-4sarge2\n');
}
if (deb_check(prefix: 'mount', release: '3.1', reference: '2.12p-4sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mount is vulnerable in Debian 3.1.\nUpgrade to mount_2.12p-4sarge2\n');
}
if (deb_check(prefix: 'util-linux', release: '3.1', reference: '2.12p-4sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package util-linux is vulnerable in Debian 3.1.\nUpgrade to util-linux_2.12p-4sarge2\n');
}
if (deb_check(prefix: 'util-linux-locales', release: '3.1', reference: '2.12p-4sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package util-linux-locales is vulnerable in Debian 3.1.\nUpgrade to util-linux-locales_2.12p-4sarge2\n');
}
if (deb_check(prefix: 'bsdutils', release: '4.0', reference: '2.12r-19etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package bsdutils is vulnerable in Debian 4.0.\nUpgrade to bsdutils_2.12r-19etch1\n');
}
if (deb_check(prefix: 'mount', release: '4.0', reference: '2.12r-19etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mount is vulnerable in Debian 4.0.\nUpgrade to mount_2.12r-19etch1\n');
}
if (deb_check(prefix: 'util-linux', release: '4.0', reference: '2.12r-19etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package util-linux is vulnerable in Debian 4.0.\nUpgrade to util-linux_2.12r-19etch1\n');
}
if (deb_check(prefix: 'util-linux-locales', release: '4.0', reference: '2.12r-19etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package util-linux-locales is vulnerable in Debian 4.0.\nUpgrade to util-linux-locales_2.12r-19etch1\n');
}
if (deb_check(prefix: 'util-linux', release: '4.0', reference: '2.12r-19etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package util-linux is vulnerable in Debian etch.\nUpgrade to util-linux_2.12r-19etch1\n');
}
if (deb_check(prefix: 'util-linux', release: '3.1', reference: '2.12p-4sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package util-linux is vulnerable in Debian sarge.\nUpgrade to util-linux_2.12p-4sarge2\n');
}
if (w) { security_hole(port: 0, data: desc); }
