# This script was automatically generated from the dsa-1451
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Several local/remote vulnerabilities have been discovered in the MySQL
database server. The Common Vulnerabilities and Exposures project
identifies the following problems:

    
    It was discovered that the privilege validation for the source table
    of CREATE TABLE LIKE statements was insufficiently enforced, which
    might lead to information disclosure. This is only exploitable by
    authenticated users.
    
    
    It was discovered that symbolic links were handled insecurely during
    the creation of tables with DATA DIRECTORY or INDEX DIRECTORY
    statements, which might lead to denial of service by overwriting
    data. This is only exploitable by authenticated users.
    
    
    It was discovered that queries to data in a FEDERATED table can
    lead to a crash of the local database server, if the remote server
    returns information with less columns than expected, resulting in
    denial of service.
    

The old stable distribution (sarge) doesn\'t contain mysql-dfsg-5.0.


For the stable distribution (etch), these problems have been fixed in
version 5.0.32-7etch4.


For the unstable distribution (sid), these problems have been fixed in
version 5.0.51-1.


We recommend that you upgrade your mysql-dfsg-5.0 packages.



Solution : http://www.debian.org/security/2008/dsa-1451
Risk factor : High';

if (description) {
 script_id(29860);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1451");
 script_cve_id("CVE-2007-3781", "CVE-2007-5969", "CVE-2007-6304");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1451] DSA-1451-1 mysql-dfsg-5.0");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1451-1 mysql-dfsg-5.0");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libmysqlclient15-dev', release: '4.0', reference: '5.0.32-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmysqlclient15-dev is vulnerable in Debian 4.0.\nUpgrade to libmysqlclient15-dev_5.0.32-7etch4\n');
}
if (deb_check(prefix: 'libmysqlclient15off', release: '4.0', reference: '5.0.32-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmysqlclient15off is vulnerable in Debian 4.0.\nUpgrade to libmysqlclient15off_5.0.32-7etch4\n');
}
if (deb_check(prefix: 'mysql-client', release: '4.0', reference: '5.0.32-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-client is vulnerable in Debian 4.0.\nUpgrade to mysql-client_5.0.32-7etch4\n');
}
if (deb_check(prefix: 'mysql-client-5.0', release: '4.0', reference: '5.0.32-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-client-5.0 is vulnerable in Debian 4.0.\nUpgrade to mysql-client-5.0_5.0.32-7etch4\n');
}
if (deb_check(prefix: 'mysql-common', release: '4.0', reference: '5.0.32-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-common is vulnerable in Debian 4.0.\nUpgrade to mysql-common_5.0.32-7etch4\n');
}
if (deb_check(prefix: 'mysql-server', release: '4.0', reference: '5.0.32-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-server is vulnerable in Debian 4.0.\nUpgrade to mysql-server_5.0.32-7etch4\n');
}
if (deb_check(prefix: 'mysql-server-4.1', release: '4.0', reference: '5.0.32-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-server-4.1 is vulnerable in Debian 4.0.\nUpgrade to mysql-server-4.1_5.0.32-7etch4\n');
}
if (deb_check(prefix: 'mysql-server-5.0', release: '4.0', reference: '5.0.32-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-server-5.0 is vulnerable in Debian 4.0.\nUpgrade to mysql-server-5.0_5.0.32-7etch4\n');
}
if (deb_check(prefix: 'mysql-dfsg-5.0', release: '4.0', reference: '5.0.32-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-dfsg-5.0 is vulnerable in Debian etch.\nUpgrade to mysql-dfsg-5.0_5.0.32-7etch4\n');
}
if (w) { security_hole(port: 0, data: desc); }
