# This script was automatically generated from the dsa-1455
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several local/remote vulnerabilities have been discovered in libarchive1,
a single library to read/write tar, cpio, pax, zip, iso9660 archives.
The Common Vulnerabilities and Exposures project identifies the following
problems:
  It was discovered that libarchive1 would miscompute the length of a buffer
  resulting in a buffer overflow if yet another type of corruption occurred
  in a pax extension header.
  It was discovered that if an archive prematurely ended within a pax
  extension header the libarchive1 library could enter an infinite loop.
  If an archive prematurely ended within a tar header, immediately following
  a pax extension header, libarchive1 could dereference a NULL pointer.
The old stable distribution (sarge), does not contain this package.
For the stable distribution (etch), these problems have been fixed in
version 1.2.53-2etch1.
For the unstable distribution (sid), these problems have been fixed in
version 2.2.4-1.
We recommend that you upgrade your libarchive package.


Solution : http://www.debian.org/security/2008/dsa-1455
Risk factor : High';

if (description) {
 script_id(29902);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1455");
 script_cve_id("CVE-2007-3641", "CVE-2007-3644", "CVE-2007-3645");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1455] DSA-1455-1 libarchive");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1455-1 libarchive");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'bsdtar', release: '4.0', reference: '1.2.53-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package bsdtar is vulnerable in Debian 4.0.\nUpgrade to bsdtar_1.2.53-2etch1\n');
}
if (deb_check(prefix: 'libarchive-dev', release: '4.0', reference: '1.2.53-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libarchive-dev is vulnerable in Debian 4.0.\nUpgrade to libarchive-dev_1.2.53-2etch1\n');
}
if (deb_check(prefix: 'libarchive1', release: '4.0', reference: '1.2.53-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libarchive1 is vulnerable in Debian 4.0.\nUpgrade to libarchive1_1.2.53-2etch1\n');
}
if (deb_check(prefix: 'libarchive1', release: '4.0', reference: '1.2.53-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libarchive1 is vulnerable in Debian etch.\nUpgrade to libarchive1_1.2.53-2etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
