# This script was automatically generated from the dsa-1457
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

It was discovered that Dovecot, a POP3 and IMAP server, only when used
# Remark: "base" refers to a variable(?!) and should not contain something as
# base = %r!
with LDAP authentication and <q>base</q> contains variables, could allow
a user to log in to the account of another user with the same password.


The old stable distribution (sarge) is not affected.


For the stable distribution (etch), this problem has been fixed in
version 1.0.rc15-2etch3.


For the unstable distribution (sid), this problem has been fixed in
version 1.0.10-1.


We recommend that you upgrade your dovecot packages.



Solution : http://www.debian.org/security/2008/dsa-1457
Risk factor : High';

if (description) {
 script_id(29904);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1457");
 script_cve_id("CVE-2007-6598");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1457] DSA-1457-1 dovecot");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1457-1 dovecot");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'dovecot-common', release: '4.0', reference: '1.0.rc15-2etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dovecot-common is vulnerable in Debian 4.0.\nUpgrade to dovecot-common_1.0.rc15-2etch3\n');
}
if (deb_check(prefix: 'dovecot-imapd', release: '4.0', reference: '1.0.rc15-2etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dovecot-imapd is vulnerable in Debian 4.0.\nUpgrade to dovecot-imapd_1.0.rc15-2etch3\n');
}
if (deb_check(prefix: 'dovecot-pop3d', release: '4.0', reference: '1.0.rc15-2etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dovecot-pop3d is vulnerable in Debian 4.0.\nUpgrade to dovecot-pop3d_1.0.rc15-2etch3\n');
}
if (deb_check(prefix: 'dovecot', release: '4.0', reference: '1.0.rc15-2etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dovecot is vulnerable in Debian etch.\nUpgrade to dovecot_1.0.rc15-2etch3\n');
}
if (w) { security_hole(port: 0, data: desc); }
