# This script was automatically generated from the dsa-1458
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

A race condition in the OpenAFS fileserver allows remote attackers to
cause a denial of service (daemon crash) by simultaneously acquiring and
giving back file callbacks, which causes the handler for the
GiveUpAllCallBacks RPC to perform linked-list operations without the
host_glock lock.


For the old stable distribution (sarge), this problem has been fixed in
version 1.3.81-3sarge3.


For the stable distribution (etch), this problem has been fixed in
version 1.4.2-6etch1.


We recommend that you upgrade your openafs packages.



Solution : http://www.debian.org/security/2008/dsa-1458
Risk factor : High';

if (description) {
 script_id(29935);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1458");
 script_cve_id("CVE-2007-6599");
 script_bugtraq_id(27132);

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1458] DSA-1458-1 openafs");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1458-1 openafs");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libopenafs-dev', release: '3.1', reference: '1.3.81-3sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libopenafs-dev is vulnerable in Debian 3.1.\nUpgrade to libopenafs-dev_1.3.81-3sarge3\n');
}
if (deb_check(prefix: 'libpam-openafs-kaserver', release: '3.1', reference: '1.3.81-3sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpam-openafs-kaserver is vulnerable in Debian 3.1.\nUpgrade to libpam-openafs-kaserver_1.3.81-3sarge3\n');
}
if (deb_check(prefix: 'openafs-client', release: '3.1', reference: '1.3.81-3sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-client is vulnerable in Debian 3.1.\nUpgrade to openafs-client_1.3.81-3sarge3\n');
}
if (deb_check(prefix: 'openafs-dbserver', release: '3.1', reference: '1.3.81-3sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-dbserver is vulnerable in Debian 3.1.\nUpgrade to openafs-dbserver_1.3.81-3sarge3\n');
}
if (deb_check(prefix: 'openafs-fileserver', release: '3.1', reference: '1.3.81-3sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-fileserver is vulnerable in Debian 3.1.\nUpgrade to openafs-fileserver_1.3.81-3sarge3\n');
}
if (deb_check(prefix: 'openafs-kpasswd', release: '3.1', reference: '1.3.81-3sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-kpasswd is vulnerable in Debian 3.1.\nUpgrade to openafs-kpasswd_1.3.81-3sarge3\n');
}
if (deb_check(prefix: 'openafs-modules-source', release: '3.1', reference: '1.3.81-3sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-modules-source is vulnerable in Debian 3.1.\nUpgrade to openafs-modules-source_1.3.81-3sarge3\n');
}
if (deb_check(prefix: 'libopenafs-dev', release: '4.0', reference: '1.4.2-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libopenafs-dev is vulnerable in Debian 4.0.\nUpgrade to libopenafs-dev_1.4.2-6etch1\n');
}
if (deb_check(prefix: 'libpam-openafs-kaserver', release: '4.0', reference: '1.4.2-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpam-openafs-kaserver is vulnerable in Debian 4.0.\nUpgrade to libpam-openafs-kaserver_1.4.2-6etch1\n');
}
if (deb_check(prefix: 'openafs-client', release: '4.0', reference: '1.4.2-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-client is vulnerable in Debian 4.0.\nUpgrade to openafs-client_1.4.2-6etch1\n');
}
if (deb_check(prefix: 'openafs-dbg', release: '4.0', reference: '1.4.2-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-dbg is vulnerable in Debian 4.0.\nUpgrade to openafs-dbg_1.4.2-6etch1\n');
}
if (deb_check(prefix: 'openafs-dbserver', release: '4.0', reference: '1.4.2-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-dbserver is vulnerable in Debian 4.0.\nUpgrade to openafs-dbserver_1.4.2-6etch1\n');
}
if (deb_check(prefix: 'openafs-doc', release: '4.0', reference: '1.4.2-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-doc is vulnerable in Debian 4.0.\nUpgrade to openafs-doc_1.4.2-6etch1\n');
}
if (deb_check(prefix: 'openafs-fileserver', release: '4.0', reference: '1.4.2-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-fileserver is vulnerable in Debian 4.0.\nUpgrade to openafs-fileserver_1.4.2-6etch1\n');
}
if (deb_check(prefix: 'openafs-kpasswd', release: '4.0', reference: '1.4.2-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-kpasswd is vulnerable in Debian 4.0.\nUpgrade to openafs-kpasswd_1.4.2-6etch1\n');
}
if (deb_check(prefix: 'openafs-krb5', release: '4.0', reference: '1.4.2-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-krb5 is vulnerable in Debian 4.0.\nUpgrade to openafs-krb5_1.4.2-6etch1\n');
}
if (deb_check(prefix: 'openafs-modules-source', release: '4.0', reference: '1.4.2-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-modules-source is vulnerable in Debian 4.0.\nUpgrade to openafs-modules-source_1.4.2-6etch1\n');
}
if (deb_check(prefix: 'openafs', release: '4.0', reference: '1.4.2-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs is vulnerable in Debian etch.\nUpgrade to openafs_1.4.2-6etch1\n');
}
if (deb_check(prefix: 'openafs', release: '3.1', reference: '1.3.81-3sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs is vulnerable in Debian sarge.\nUpgrade to openafs_1.3.81-3sarge3\n');
}
if (w) { security_hole(port: 0, data: desc); }
