# This script was automatically generated from the dsa-1462
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Kees Cook discovered that the hpssd tool of the HP Linux Printing and
Imaging System (HPLIP) performs insufficient input sanitising of shell
meta characters, which may result in local privilege escalation to
the hplip user.


The old stable distribution (sarge) is not affected by this problem.


For the stable distribution (etch), this problem has been fixed in
version 1.6.10-3etch1.


For the unstable distribution (sid), this problem has been fixed in
version 1.6.10-4.3.


We recommend that you upgrade your hplip packages.



Solution : http://www.debian.org/security/2008/dsa-1462
Risk factor : High';

if (description) {
 script_id(29939);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1462");
 script_cve_id("CVE-2007-5208");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1462] DSA-1462-1 hplip");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1462-1 hplip");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'hpijs', release: '4.0', reference: '2.6.10+1.6.10-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hpijs is vulnerable in Debian 4.0.\nUpgrade to hpijs_2.6.10+1.6.10-3etch1\n');
}
if (deb_check(prefix: 'hpijs-ppds', release: '4.0', reference: '2.6.10+1.6.10-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hpijs-ppds is vulnerable in Debian 4.0.\nUpgrade to hpijs-ppds_2.6.10+1.6.10-3etch1\n');
}
if (deb_check(prefix: 'hplip', release: '4.0', reference: '1.6.10-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hplip is vulnerable in Debian 4.0.\nUpgrade to hplip_1.6.10-3etch1\n');
}
if (deb_check(prefix: 'hplip-data', release: '4.0', reference: '1.6.10-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hplip-data is vulnerable in Debian 4.0.\nUpgrade to hplip-data_1.6.10-3etch1\n');
}
if (deb_check(prefix: 'hplip-dbg', release: '4.0', reference: '1.6.10-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hplip-dbg is vulnerable in Debian 4.0.\nUpgrade to hplip-dbg_1.6.10-3etch1\n');
}
if (deb_check(prefix: 'hplip-doc', release: '4.0', reference: '1.6.10-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hplip-doc is vulnerable in Debian 4.0.\nUpgrade to hplip-doc_1.6.10-3etch1\n');
}
if (deb_check(prefix: 'hplip', release: '4.0', reference: '1.6.10-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hplip is vulnerable in Debian etch.\nUpgrade to hplip_1.6.10-3etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
