# This script was automatically generated from the dsa-1467
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in Mantis, a web based
bug tracking system. The Common Vulnerabilities and Exposures project
identifies the following problems:
    Custom fields were not appropriately protected by per-item access
    control, allowing for sensitive data to be published.
    Multiple cross site scripting issues allowed a remote attacker to
    insert malicious HTML or web script into Mantis web pages.
For the old stable distribution (sarge), these problems have been fixed in
version 0.19.2-5sarge5.
The stable distribution (etch) is not affected by these problems.
For the unstable distribution (sid), these problems have been fixed in
version 1.0.8-4.
We recommend that you upgrade your mantis package.


Solution : http://www.debian.org/security/2008/dsa-1467
Risk factor : High';

if (description) {
 script_id(30023);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1467");
 script_cve_id("CVE-2006-6574", "CVE-2007-6611");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1467] DSA-1467-1 mantis");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1467-1 mantis");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'mantis', release: '3.1', reference: '0.19.2-5sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mantis is vulnerable in Debian 3.1.\nUpgrade to mantis_0.19.2-5sarge5\n');
}
if (deb_check(prefix: 'mantis', release: '3.1', reference: '0.19.2-5sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mantis is vulnerable in Debian sarge.\nUpgrade to mantis_0.19.2-5sarge5\n');
}
if (w) { security_hole(port: 0, data: desc); }
