# This script was automatically generated from the dsa-1468
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Tomcat
servlet and JSP engine. The Common Vulnerabilities and Exposures project
identifies the following problems:
    Olaf Kock discovered that HTTPS encryption was insufficiently
    enforced for single-sign-on cookies, which could result in
    information disclosure.
    It was discovered that the Manager and Host Manager web applications
    performed insufficient input sanitising, which could lead to cross site
    scripting.
This update also adapts the tomcat5.5-webapps package to the tightened
JULI permissions introduced in the previous tomcat5.5 DSA. However, it
should be noted, that the tomcat5.5-webapps is for demonstration and
documentation purposes only and should not be used for production
systems.
The old stable distribution (sarge) doesn\'t contain tomcat5.5.
For the stable distribution (etch), these problems have been fixed in
version 5.5.20-2etch2.
For the unstable distribution (sid), these problems will be fixed soon.
We recommend that you upgrade your tomcat5.5 packages.


Solution : http://www.debian.org/security/2008/dsa-1468
Risk factor : High';

if (description) {
 script_id(30060);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1468");
 script_cve_id("CVE-2007-2450", "CVE-2008-0128");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1468] DSA-1468-1 tomcat5.5");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1468-1 tomcat5.5");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libtomcat5.5-java', release: '4.0', reference: '5.5.20-2etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libtomcat5.5-java is vulnerable in Debian 4.0.\nUpgrade to libtomcat5.5-java_5.5.20-2etch2\n');
}
if (deb_check(prefix: 'tomcat5.5', release: '4.0', reference: '5.5.20-2etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tomcat5.5 is vulnerable in Debian 4.0.\nUpgrade to tomcat5.5_5.5.20-2etch2\n');
}
if (deb_check(prefix: 'tomcat5.5-admin', release: '4.0', reference: '5.5.20-2etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tomcat5.5-admin is vulnerable in Debian 4.0.\nUpgrade to tomcat5.5-admin_5.5.20-2etch2\n');
}
if (deb_check(prefix: 'tomcat5.5-webapps', release: '4.0', reference: '5.5.20-2etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tomcat5.5-webapps is vulnerable in Debian 4.0.\nUpgrade to tomcat5.5-webapps_5.5.20-2etch2\n');
}
if (deb_check(prefix: 'tomcat5.5', release: '4.0', reference: '5.5.20-2etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tomcat5.5 is vulnerable in Debian etch.\nUpgrade to tomcat5.5_5.5.20-2etch2\n');
}
if (w) { security_hole(port: 0, data: desc); }
