# This script was automatically generated from the dsa-1471
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several vulnerabilities were found in the Vorbis General Audio
Compression Codec, which may lead to denial of service or the
execution of arbitrary code, if a user is tricked into opening
a malformed Ogg Audio file with an application linked against
libvorbis.
For the old stable distribution (sarge), these problems have been fixed
in version 1.1.0-2.
For the stable distribution (etch), these problems have been fixed in
version 1.1.2.dfsg-1.3.
For the unstable distribution (sid), these problems have been fixed in
version 1.2.0.dfsg-1.
We recommend that you upgrade your libvorbis packages.


Solution : http://www.debian.org/security/2008/dsa-1471
Risk factor : High';

if (description) {
 script_id(30063);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1471");
 script_cve_id("CVE-2007-3106", "CVE-2007-4029", "CVE-2007-4066");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1471] DSA-1471-1 libvorbis");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1471-1 libvorbis");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libvorbis-dev', release: '3.1', reference: '1.1.0-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libvorbis-dev is vulnerable in Debian 3.1.\nUpgrade to libvorbis-dev_1.1.0-2\n');
}
if (deb_check(prefix: 'libvorbis0a', release: '3.1', reference: '1.1.0-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libvorbis0a is vulnerable in Debian 3.1.\nUpgrade to libvorbis0a_1.1.0-2\n');
}
if (deb_check(prefix: 'libvorbisenc2', release: '3.1', reference: '1.1.0-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libvorbisenc2 is vulnerable in Debian 3.1.\nUpgrade to libvorbisenc2_1.1.0-2\n');
}
if (deb_check(prefix: 'libvorbisfile3', release: '3.1', reference: '1.1.0-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libvorbisfile3 is vulnerable in Debian 3.1.\nUpgrade to libvorbisfile3_1.1.0-2\n');
}
if (deb_check(prefix: 'libvorbis-dev', release: '4.0', reference: '1.1.2.dfsg-1.3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libvorbis-dev is vulnerable in Debian 4.0.\nUpgrade to libvorbis-dev_1.1.2.dfsg-1.3\n');
}
if (deb_check(prefix: 'libvorbis0a', release: '4.0', reference: '1.1.2.dfsg-1.3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libvorbis0a is vulnerable in Debian 4.0.\nUpgrade to libvorbis0a_1.1.2.dfsg-1.3\n');
}
if (deb_check(prefix: 'libvorbisenc2', release: '4.0', reference: '1.1.2.dfsg-1.3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libvorbisenc2 is vulnerable in Debian 4.0.\nUpgrade to libvorbisenc2_1.1.2.dfsg-1.3\n');
}
if (deb_check(prefix: 'libvorbisfile3', release: '4.0', reference: '1.1.2.dfsg-1.3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libvorbisfile3 is vulnerable in Debian 4.0.\nUpgrade to libvorbisfile3_1.1.2.dfsg-1.3\n');
}
if (deb_check(prefix: 'libvorbis', release: '4.0', reference: '1.1.2.dfsg-1.3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libvorbis is vulnerable in Debian etch.\nUpgrade to libvorbis_1.1.2.dfsg-1.3\n');
}
if (deb_check(prefix: 'libvorbis', release: '3.1', reference: '1.1.0-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libvorbis is vulnerable in Debian sarge.\nUpgrade to libvorbis_1.1.0-2\n');
}
if (w) { security_hole(port: 0, data: desc); }
