# This script was automatically generated from the dsa-1473
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Joachim Breitner discovered that Subversion support in scponly is
inherently insecure, allowing execution of arbitrary commands.  Further
investigation showed that rsync and Unison support suffer from similar
issues.  This set of issues has been assigned CVE-2007-6350.
In addition, it was discovered that it was possible to invoke scp
with certain options that may lead to the execution of arbitrary commands
(CVE-2007-6415).
This update removes Subversion, rsync and Unison support from the
scponly package, and prevents scp from being invoked with the dangerous
options.
For the old stable distribution (sarge), these problems have been fixed
in version 4.0-1sarge2.
For the stable distribution (etch), these problems have been fixed in
version 4.6-1etch1.
The unstable distribution (sid) will be fixed soon.
We recommend that you upgrade your scponly package.


Solution : http://www.debian.org/security/2008/dsa-1473
Risk factor : High';

if (description) {
 script_id(30065);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1473");
 script_cve_id("CVE-2007-6350", "CVE-2007-6415");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1473] DSA-1473-1 scponly");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1473-1 scponly");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'scponly', release: '3.1', reference: '4.0-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package scponly is vulnerable in Debian 3.1.\nUpgrade to scponly_4.0-1sarge2\n');
}
if (deb_check(prefix: 'scponly', release: '4.0', reference: '4.6-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package scponly is vulnerable in Debian 4.0.\nUpgrade to scponly_4.6-1etch1\n');
}
if (deb_check(prefix: 'scponly', release: '4.0', reference: '4.6-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package scponly is vulnerable in Debian etch.\nUpgrade to scponly_4.6-1etch1\n');
}
if (deb_check(prefix: 'scponly', release: '3.1', reference: '4.0-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package scponly is vulnerable in Debian sarge.\nUpgrade to scponly_4.0-1sarge2\n');
}
if (w) { security_hole(port: 0, data: desc); }
