# This script was automatically generated from the dsa-1474
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Meder Kydyraliev discovered an integer overflow in the thumbnail
handling of libexif, the EXIF/IPTC metadata manipulation library, which
could result in the execution of arbitrary code.
The old stable distribution (sarge) doesn\'t contain exiv2 packages.
For the stable distribution (etch), this problem has been fixed in
version 0.10-1.5.
We recommend that you upgrade your exiv2 packages.


Solution : http://www.debian.org/security/2008/dsa-1474
Risk factor : High';

if (description) {
 script_id(30066);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1474");
 script_cve_id("CVE-2007-6353");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1474] DSA-1474-1 exiv2");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1474-1 exiv2");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'exiv2', release: '4.0', reference: '0.10-1.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package exiv2 is vulnerable in Debian 4.0.\nUpgrade to exiv2_0.10-1.5\n');
}
if (deb_check(prefix: 'libexiv2-0.10', release: '4.0', reference: '0.10-1.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libexiv2-0.10 is vulnerable in Debian 4.0.\nUpgrade to libexiv2-0.10_0.10-1.5\n');
}
if (deb_check(prefix: 'libexiv2-dev', release: '4.0', reference: '0.10-1.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libexiv2-dev is vulnerable in Debian 4.0.\nUpgrade to libexiv2-dev_0.10-1.5\n');
}
if (deb_check(prefix: 'libexiv2-doc', release: '4.0', reference: '0.10-1.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libexiv2-doc is vulnerable in Debian 4.0.\nUpgrade to libexiv2-doc_0.10-1.5\n');
}
if (deb_check(prefix: 'exiv2', release: '4.0', reference: '0.10-1.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package exiv2 is vulnerable in Debian etch.\nUpgrade to exiv2_0.10-1.5\n');
}
if (w) { security_hole(port: 0, data: desc); }
