# This script was automatically generated from the dsa-1478
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Luigi Auriemma discovered two buffer overflows in YaSSL, an SSL
implementation included in the MySQL database package, which could lead
to denial of service and possibly the execution of arbitrary code.
The old stable distribution (sarge) doesn\'t contain mysql-dfsg-5.0.
For the stable distribution (etch), these problems have been fixed in
version 5.0.32-7etch5.
For the unstable distribution (sid), these problems have been fixed in
version 5.0.51-3.
We recommend that you upgrade your mysql-dfsg-5.0 package.


Solution : http://www.debian.org/security/2008/dsa-1478
Risk factor : High';

if (description) {
 script_id(30125);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1478");
 script_cve_id("CVE-2008-0226", "CVE-2008-0227");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1478] DSA-1478-1 mysql-dfsg-5.0");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1478-1 mysql-dfsg-5.0");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libmysqlclient15-dev', release: '4.0', reference: '5.0.32-7etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmysqlclient15-dev is vulnerable in Debian 4.0.\nUpgrade to libmysqlclient15-dev_5.0.32-7etch5\n');
}
if (deb_check(prefix: 'libmysqlclient15off', release: '4.0', reference: '5.0.32-7etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmysqlclient15off is vulnerable in Debian 4.0.\nUpgrade to libmysqlclient15off_5.0.32-7etch5\n');
}
if (deb_check(prefix: 'mysql-client', release: '4.0', reference: '5.0.32-7etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-client is vulnerable in Debian 4.0.\nUpgrade to mysql-client_5.0.32-7etch5\n');
}
if (deb_check(prefix: 'mysql-client-5.0', release: '4.0', reference: '5.0.32-7etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-client-5.0 is vulnerable in Debian 4.0.\nUpgrade to mysql-client-5.0_5.0.32-7etch5\n');
}
if (deb_check(prefix: 'mysql-common', release: '4.0', reference: '5.0.32-7etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-common is vulnerable in Debian 4.0.\nUpgrade to mysql-common_5.0.32-7etch5\n');
}
if (deb_check(prefix: 'mysql-server', release: '4.0', reference: '5.0.32-7etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-server is vulnerable in Debian 4.0.\nUpgrade to mysql-server_5.0.32-7etch5\n');
}
if (deb_check(prefix: 'mysql-server-4.1', release: '4.0', reference: '5.0.32-7etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-server-4.1 is vulnerable in Debian 4.0.\nUpgrade to mysql-server-4.1_5.0.32-7etch5\n');
}
if (deb_check(prefix: 'mysql-server-5.0', release: '4.0', reference: '5.0.32-7etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-server-5.0 is vulnerable in Debian 4.0.\nUpgrade to mysql-server-5.0_5.0.32-7etch5\n');
}
if (deb_check(prefix: 'mysql-dfsg-5.0', release: '4.0', reference: '5.0.32-7etch5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mysql-dfsg-5.0 is vulnerable in Debian etch.\nUpgrade to mysql-dfsg-5.0_5.0.32-7etch5\n');
}
if (w) { security_hole(port: 0, data: desc); }
