# This script was automatically generated from the dsa-1479
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several local vulnerabilities have been discovered in the Linux kernel
that may lead to a denial of service or the execution of arbitrary
code. The Common Vulnerabilities and Exposures project identifies the
following problems:
    Bart Oldeman reported a denial of service (DoS) issue in the VFAT
    filesystem that allows local users to corrupt a kernel structure resulting
    in a system crash. This is only an issue for systems which make use
    of the VFAT compat ioctl interface, such as systems running an \'amd64\'
    flavor kernel.
    Takashi Iwai supplied a fix for a memory leak in the snd_page_alloc module.
    Local users could exploit this issue to obtain sensitive information from
    the kernel.
    ADLAB discovered a possible memory overrun in the ISDN subsystem that
    may permit a local user to overwrite kernel memory leading by issuing
    ioctls with unterminated data.
    Bill Roman of Datalight noticed a coding error in the linux VFS subsystem
    that, under certain conditions, can allow local users to remove
    directories for which they should not have removal privileges. 
These problems have been fixed in the stable distribution in version
2.6.18.dfsg.1-17etch1.
We recommend that you upgrade your kernel packages immediately and reboot
the machine. If you have built a custom kernel from the kernel source
package, you will need to rebuild to take advantage of these fixes.


Solution : http://www.debian.org/security/2008/dsa-1479
Risk factor : High';

if (description) {
 script_id(30126);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1479");
 script_cve_id("CVE-2007-2878", "CVE-2007-4571", "CVE-2007-6151", "CVE-2008-0001");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1479] DSA-1479-1 linux-2.6");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1479-1 linux-2.6");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'fai-kernels', release: '4.0', reference: '1.17+etch.17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package fai-kernels is vulnerable in Debian 4.0.\nUpgrade to fai-kernels_1.17+etch.17etch1\n');
}
if (deb_check(prefix: 'gspca-modules-2.6-486', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6-486 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6-486_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6-686', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6-686 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6-686_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6-686-bigmem', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6-686-bigmem_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6-amd64', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6-amd64 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6-amd64_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6-k7', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6-k7 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6-k7_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6-vserver-686', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6-vserver-686_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6-vserver-k7', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6-vserver-k7_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6-xen-686', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6-xen-686_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6-xen-vserver-686', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6-xen-vserver-686_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6.18-6-486', release: '4.0', reference: '2.6.18+01.00.04-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6.18-6-486 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6.18-6-486_2.6.18+01.00.04-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6.18-6-686', release: '4.0', reference: '2.6.18+01.00.04-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6.18-6-686 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6.18-6-686_2.6.18+01.00.04-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6.18-6-686-bigmem', release: '4.0', reference: '2.6.18+01.00.04-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6.18-6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6.18-6-686-bigmem_2.6.18+01.00.04-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6.18-6-amd64', release: '4.0', reference: '2.6.18+01.00.04-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6.18-6-amd64 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6.18-6-amd64_2.6.18+01.00.04-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6.18-6-k7', release: '4.0', reference: '2.6.18+01.00.04-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6.18-6-k7 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6.18-6-k7_2.6.18+01.00.04-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6.18-6-vserver-686', release: '4.0', reference: '2.6.18+01.00.04-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6.18-6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6.18-6-vserver-686_2.6.18+01.00.04-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6.18-6-vserver-k7', release: '4.0', reference: '2.6.18+01.00.04-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6.18-6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6.18-6-vserver-k7_2.6.18+01.00.04-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6.18-6-xen-686', release: '4.0', reference: '2.6.18+01.00.04-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6.18-6-xen-686_2.6.18+01.00.04-7+etch4\n');
}
if (deb_check(prefix: 'gspca-modules-2.6.18-6-xen-vserver-686', release: '4.0', reference: '2.6.18+01.00.04-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gspca-modules-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to gspca-modules-2.6.18-6-xen-vserver-686_2.6.18+01.00.04-7+etch4\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6-486', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6-486 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6-486_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6-686-bigmem', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6-686-bigmem_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6-amd64', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6-amd64 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6-amd64_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6-k7', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6-k7 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6-k7_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6-vserver-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6-vserver-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6-vserver-k7', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6-vserver-k7_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6-xen-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6-xen-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6-xen-vserver-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6-xen-vserver-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6.18-6-486', release: '4.0', reference: '2.6.18+1.2.1-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6.18-6-486 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6.18-6-486_2.6.18+1.2.1-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6.18-6-686', release: '4.0', reference: '2.6.18+1.2.1-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6.18-6-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6.18-6-686_2.6.18+1.2.1-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6.18-6-686-bigmem', release: '4.0', reference: '2.6.18+1.2.1-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6.18-6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6.18-6-686-bigmem_2.6.18+1.2.1-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6.18-6-amd64', release: '4.0', reference: '2.6.18+1.2.1-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6.18-6-amd64 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6.18-6-amd64_2.6.18+1.2.1-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6.18-6-k7', release: '4.0', reference: '2.6.18+1.2.1-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6.18-6-k7 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6.18-6-k7_2.6.18+1.2.1-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6.18-6-vserver-686', release: '4.0', reference: '2.6.18+1.2.1-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6.18-6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6.18-6-vserver-686_2.6.18+1.2.1-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6.18-6-vserver-k7', release: '4.0', reference: '2.6.18+1.2.1-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6.18-6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6.18-6-vserver-k7_2.6.18+1.2.1-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6.18-6-xen-686', release: '4.0', reference: '2.6.18+1.2.1-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6.18-6-xen-686_2.6.18+1.2.1-4+etch3\n');
}
if (deb_check(prefix: 'ipw2100-modules-2.6.18-6-xen-vserver-686', release: '4.0', reference: '2.6.18+1.2.1-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2100-modules-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2100-modules-2.6.18-6-xen-vserver-686_2.6.18+1.2.1-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6-486', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6-486 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6-486_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6-686-bigmem', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6-686-bigmem_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6-amd64', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6-amd64 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6-amd64_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6-k7', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6-k7 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6-k7_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6-vserver-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6-vserver-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6-vserver-k7', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6-vserver-k7_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6-xen-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6-xen-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6-xen-vserver-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6-xen-vserver-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6.18-6-486', release: '4.0', reference: '2.6.18+1.2.0-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6.18-6-486 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6.18-6-486_2.6.18+1.2.0-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6.18-6-686', release: '4.0', reference: '2.6.18+1.2.0-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6.18-6-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6.18-6-686_2.6.18+1.2.0-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6.18-6-686-bigmem', release: '4.0', reference: '2.6.18+1.2.0-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6.18-6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6.18-6-686-bigmem_2.6.18+1.2.0-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6.18-6-amd64', release: '4.0', reference: '2.6.18+1.2.0-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6.18-6-amd64 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6.18-6-amd64_2.6.18+1.2.0-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6.18-6-k7', release: '4.0', reference: '2.6.18+1.2.0-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6.18-6-k7 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6.18-6-k7_2.6.18+1.2.0-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6.18-6-vserver-686', release: '4.0', reference: '2.6.18+1.2.0-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6.18-6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6.18-6-vserver-686_2.6.18+1.2.0-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6.18-6-vserver-k7', release: '4.0', reference: '2.6.18+1.2.0-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6.18-6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6.18-6-vserver-k7_2.6.18+1.2.0-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6.18-6-xen-686', release: '4.0', reference: '2.6.18+1.2.0-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6.18-6-xen-686_2.6.18+1.2.0-4+etch3\n');
}
if (deb_check(prefix: 'ipw2200-modules-2.6.18-6-xen-vserver-686', release: '4.0', reference: '2.6.18+1.2.0-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw2200-modules-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ipw2200-modules-2.6.18-6-xen-vserver-686_2.6.18+1.2.0-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6-486', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6-486 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6-486_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6-686 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6-686-bigmem', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6-686-bigmem_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6-amd64', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6-amd64 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6-amd64_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6-k7', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6-k7 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6-k7_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6-vserver-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6-vserver-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6-vserver-k7', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6-vserver-k7_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6-xen-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6-xen-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6-xen-vserver-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6-xen-vserver-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6.18-6-486', release: '4.0', reference: '2.6.18+1.1.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6.18-6-486 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6.18-6-486_2.6.18+1.1.2-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6.18-6-686', release: '4.0', reference: '2.6.18+1.1.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6.18-6-686 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6.18-6-686_2.6.18+1.1.2-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6.18-6-686-bigmem', release: '4.0', reference: '2.6.18+1.1.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6.18-6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6.18-6-686-bigmem_2.6.18+1.1.2-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6.18-6-amd64', release: '4.0', reference: '2.6.18+1.1.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6.18-6-amd64 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6.18-6-amd64_2.6.18+1.1.2-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6.18-6-k7', release: '4.0', reference: '2.6.18+1.1.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6.18-6-k7 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6.18-6-k7_2.6.18+1.1.2-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6.18-6-vserver-686', release: '4.0', reference: '2.6.18+1.1.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6.18-6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6.18-6-vserver-686_2.6.18+1.1.2-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6.18-6-vserver-k7', release: '4.0', reference: '2.6.18+1.1.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6.18-6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6.18-6-vserver-k7_2.6.18+1.1.2-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6.18-6-xen-686', release: '4.0', reference: '2.6.18+1.1.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6.18-6-xen-686_2.6.18+1.1.2-4+etch3\n');
}
if (deb_check(prefix: 'ipw3945-modules-2.6.18-6-xen-vserver-686', release: '4.0', reference: '2.6.18+1.1.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ipw3945-modules-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ipw3945-modules-2.6.18-6-xen-vserver-686_2.6.18+1.1.2-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6-486', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6-486 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6-486_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6-686 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6-686-bigmem', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6-686-bigmem_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6-amd64', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6-amd64 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6-amd64_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6-k7', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6-k7 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6-k7_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6-vserver-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6-vserver-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6-vserver-k7', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6-vserver-k7_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6-xen-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6-xen-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6-xen-vserver-686', release: '4.0', reference: '2.6.18-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6-xen-vserver-686_2.6.18-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6.18-6-486', release: '4.0', reference: '2.6.18+0.8.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6.18-6-486 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6.18-6-486_2.6.18+0.8.2-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6.18-6-686', release: '4.0', reference: '2.6.18+0.8.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6.18-6-686 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6.18-6-686_2.6.18+0.8.2-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6.18-6-686-bigmem', release: '4.0', reference: '2.6.18+0.8.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6.18-6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6.18-6-686-bigmem_2.6.18+0.8.2-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6.18-6-amd64', release: '4.0', reference: '2.6.18+0.8.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6.18-6-amd64 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6.18-6-amd64_2.6.18+0.8.2-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6.18-6-k7', release: '4.0', reference: '2.6.18+0.8.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6.18-6-k7 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6.18-6-k7_2.6.18+0.8.2-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6.18-6-vserver-686', release: '4.0', reference: '2.6.18+0.8.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6.18-6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6.18-6-vserver-686_2.6.18+0.8.2-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6.18-6-vserver-k7', release: '4.0', reference: '2.6.18+0.8.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6.18-6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6.18-6-vserver-k7_2.6.18+0.8.2-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6.18-6-xen-686', release: '4.0', reference: '2.6.18+0.8.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6.18-6-xen-686_2.6.18+0.8.2-4+etch3\n');
}
if (deb_check(prefix: 'ivtv-modules-2.6.18-6-xen-vserver-686', release: '4.0', reference: '2.6.18+0.8.2-4+etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ivtv-modules-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to ivtv-modules-2.6.18-6-xen-vserver-686_2.6.18+0.8.2-4+etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-386', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-386 is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-386_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-686', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-686 is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-686_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-686-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-686-smp is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-686-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-amd64-generic', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-amd64-generic is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-amd64-generic_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-amd64-k8', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-amd64-k8 is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-amd64-k8_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-amd64-k8-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-amd64-k8-smp is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-amd64-k8-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-em64t-p4', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-em64t-p4 is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-em64t-p4_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-em64t-p4-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-em64t-p4-smp is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-em64t-p4-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-generic', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-generic is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-generic_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-itanium', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-itanium is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-itanium_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-itanium-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-itanium-smp is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-itanium-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-k7', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-k7 is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-k7_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-k7-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-k7-smp is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-k7-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-mckinley', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-mckinley is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-mckinley_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-mckinley-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-mckinley-smp is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-mckinley-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-power3', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-power3 is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-power3_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-power3-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-power3-smp is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-power3-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-power4', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-power4 is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-power4_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-power4-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-power4-smp is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-power4-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-powerpc', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-powerpc is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-powerpc_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-powerpc-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-powerpc-smp is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-powerpc-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-s390', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-s390 is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-s390_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-s390x', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-s390x is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-s390x_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-smp is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-sparc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-sparc64 is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-sparc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-2.6-sparc64-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-sparc64-smp is vulnerable in Debian 4.0.\nUpgrade to kernel-image-2.6-sparc64-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-power3', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-power3 is vulnerable in Debian 4.0.\nUpgrade to kernel-image-power3_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-power3-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-power3-smp is vulnerable in Debian 4.0.\nUpgrade to kernel-image-power3-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-power4', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-power4 is vulnerable in Debian 4.0.\nUpgrade to kernel-image-power4_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-power4-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-power4-smp is vulnerable in Debian 4.0.\nUpgrade to kernel-image-power4-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-powerpc', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-powerpc is vulnerable in Debian 4.0.\nUpgrade to kernel-image-powerpc_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kernel-image-powerpc-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-powerpc-smp is vulnerable in Debian 4.0.\nUpgrade to kernel-image-powerpc-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'kqemu-modules-2.6-486', release: '4.0', reference: '2.6.18-4etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kqemu-modules-2.6-486 is vulnerable in Debian 4.0.\nUpgrade to kqemu-modules-2.6-486_2.6.18-4etch2\n');
}
if (deb_check(prefix: 'kqemu-modules-2.6-686', release: '4.0', reference: '2.6.18-4etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kqemu-modules-2.6-686 is vulnerable in Debian 4.0.\nUpgrade to kqemu-modules-2.6-686_2.6.18-4etch2\n');
}
if (deb_check(prefix: 'kqemu-modules-2.6-686-bigmem', release: '4.0', reference: '2.6.18-4etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kqemu-modules-2.6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to kqemu-modules-2.6-686-bigmem_2.6.18-4etch2\n');
}
if (deb_check(prefix: 'kqemu-modules-2.6-k7', release: '4.0', reference: '2.6.18-4etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kqemu-modules-2.6-k7 is vulnerable in Debian 4.0.\nUpgrade to kqemu-modules-2.6-k7_2.6.18-4etch2\n');
}
if (deb_check(prefix: 'linux-doc-2.6.18', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-doc-2.6.18 is vulnerable in Debian 4.0.\nUpgrade to linux-doc-2.6.18_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6-486', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-486 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-486_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-686', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-686_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-686-bigmem', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-686-bigmem_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-alpha-generic', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-alpha-generic is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-alpha-generic_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-alpha-legacy', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-alpha-legacy is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-alpha-legacy_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-alpha-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-alpha-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-alpha-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-amd64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-amd64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-footbridge', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-footbridge is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-footbridge_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-iop32x', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-iop32x is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-iop32x_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-itanium', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-itanium is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-itanium_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-ixp4xx', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-ixp4xx is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-ixp4xx_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-k7', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-k7_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-mckinley', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-mckinley is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-mckinley_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-parisc', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-parisc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-parisc_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-parisc-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-parisc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-parisc-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-parisc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-parisc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-parisc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-parisc64-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-parisc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-parisc64-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-powerpc', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-powerpc_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-powerpc-miboot', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-powerpc-miboot is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-powerpc-miboot_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-powerpc-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-powerpc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-powerpc-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-powerpc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-powerpc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-prep', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-prep is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-prep_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-qemu', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-qemu is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-qemu_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-r3k-kn02', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-r3k-kn02 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-r3k-kn02_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-r4k-ip22', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-r4k-ip22 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-r4k-ip22_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-r4k-kn04', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-r4k-kn04 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-r4k-kn04_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-r5k-cobalt', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-r5k-cobalt is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-r5k-cobalt_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-r5k-ip32', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-r5k-ip32 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-r5k-ip32_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-rpc', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-rpc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-rpc_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-s390', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-s390 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-s390_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-s390x', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-s390x_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-s3c2410', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-s3c2410 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-s3c2410_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-sb1-bcm91250a', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-sb1-bcm91250a is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-sb1-bcm91250a_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-sb1a-bcm91480b', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-sb1a-bcm91480b is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-sb1a-bcm91480b_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-sparc32', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-sparc32 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-sparc32_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-sparc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-sparc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-sparc64-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-sparc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-sparc64-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-vserver-686', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-vserver-686_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-vserver-alpha', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-vserver-alpha is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-vserver-alpha_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-vserver-amd64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-vserver-amd64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-vserver-k7', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-vserver-k7_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-vserver-powerpc', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-vserver-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-vserver-powerpc_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-vserver-powerpc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-vserver-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-vserver-powerpc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-vserver-s390x', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-vserver-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-vserver-s390x_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-vserver-sparc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-vserver-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-vserver-sparc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-xen-686', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-xen-686_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-xen-amd64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-xen-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-xen-amd64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-xen-vserver-686', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-xen-vserver-686_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6-xen-vserver-amd64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6-xen-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6-xen-vserver-amd64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-486', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-486 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-486_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-686', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-686_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-686-bigmem', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-686-bigmem_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-alpha', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-alpha is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-alpha_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-amd64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-amd64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-arm', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-arm is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-arm_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-hppa', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-hppa is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-hppa_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-i386', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-i386 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-i386_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-ia64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-ia64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-ia64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-mips', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-mips is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-mips_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-mipsel', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-mipsel is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-mipsel_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-powerpc', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-powerpc_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-s390', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-s390 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-s390_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-all-sparc', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-all-sparc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-all-sparc_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-alpha-generic', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-alpha-generic is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-alpha-generic_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-alpha-legacy', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-alpha-legacy is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-alpha-legacy_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-alpha-smp', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-alpha-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-alpha-smp_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-amd64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-amd64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-footbridge', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-footbridge is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-footbridge_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-iop32x', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-iop32x is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-iop32x_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-itanium', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-itanium is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-itanium_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-ixp4xx', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-ixp4xx is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-ixp4xx_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-k7', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-k7_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-mckinley', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-mckinley is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-mckinley_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-parisc', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-parisc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-parisc_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-parisc-smp', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-parisc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-parisc-smp_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-parisc64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-parisc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-parisc64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-parisc64-smp', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-parisc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-parisc64-smp_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-powerpc', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-powerpc_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-powerpc-miboot', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-powerpc-miboot is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-powerpc-miboot_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-powerpc-smp', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-powerpc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-powerpc-smp_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-powerpc64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-powerpc64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-prep', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-prep is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-prep_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-qemu', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-qemu is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-qemu_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-r3k-kn02', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-r3k-kn02 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-r3k-kn02_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-r4k-ip22', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-r4k-ip22 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-r4k-ip22_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-r4k-kn04', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-r4k-kn04 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-r4k-kn04_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-r5k-cobalt', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-r5k-cobalt is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-r5k-cobalt_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-r5k-ip32', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-r5k-ip32 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-r5k-ip32_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-rpc', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-rpc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-rpc_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-s390', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-s390 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-s390_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-s390x', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-s390x_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-s3c2410', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-s3c2410 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-s3c2410_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-sb1-bcm91250a', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-sb1-bcm91250a is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-sb1-bcm91250a_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-sb1a-bcm91480b', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-sb1a-bcm91480b is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-sb1a-bcm91480b_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-sparc32', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-sparc32 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-sparc32_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-sparc64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-sparc64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-sparc64-smp', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-sparc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-sparc64-smp_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-686_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-alpha', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-alpha is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-alpha_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-amd64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-k7', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-k7_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-powerpc', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-powerpc_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-powerpc64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-powerpc64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-s390x', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-s390x_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-vserver-sparc64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-vserver-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-vserver-sparc64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-xen', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-xen is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-xen_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-xen-686', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-xen-686_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-xen-amd64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-xen-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-xen-amd64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-xen-vserver', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-xen-vserver is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-xen-vserver_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-xen-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-xen-vserver-686_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-6-xen-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-6-xen-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-6-xen-vserver-amd64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6-486', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-486 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-486_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-686', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-686_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-686-bigmem', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-686-bigmem_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-686-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-686-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-686-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-alpha-generic', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-alpha-generic is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-alpha-generic_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-alpha-legacy', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-alpha-legacy is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-alpha-legacy_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-alpha-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-alpha-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-alpha-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-amd64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-amd64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-amd64-generic', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-amd64-generic is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-amd64-generic_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-amd64-k8', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-amd64-k8 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-amd64-k8_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-amd64-k8-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-amd64-k8-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-amd64-k8-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-em64t-p4', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-em64t-p4 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-em64t-p4_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-em64t-p4-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-em64t-p4-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-em64t-p4-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-footbridge', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-footbridge is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-footbridge_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-iop32x', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-iop32x is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-iop32x_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-itanium', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-itanium is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-itanium_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-itanium-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-itanium-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-itanium-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-ixp4xx', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-ixp4xx is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-ixp4xx_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-k7', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-k7_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-k7-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-k7-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-k7-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-mckinley', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-mckinley is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-mckinley_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-mckinley-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-mckinley-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-mckinley-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-parisc', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-parisc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-parisc_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-parisc-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-parisc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-parisc-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-parisc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-parisc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-parisc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-parisc64-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-parisc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-parisc64-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-powerpc', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-powerpc_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-powerpc-miboot', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-powerpc-miboot is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-powerpc-miboot_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-powerpc-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-powerpc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-powerpc-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-powerpc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-powerpc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-prep', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-prep is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-prep_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-qemu', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-qemu is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-qemu_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-r3k-kn02', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-r3k-kn02 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-r3k-kn02_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-r4k-ip22', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-r4k-ip22 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-r4k-ip22_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-r4k-kn04', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-r4k-kn04 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-r4k-kn04_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-r5k-cobalt', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-r5k-cobalt is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-r5k-cobalt_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-r5k-ip32', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-r5k-ip32 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-r5k-ip32_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-rpc', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-rpc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-rpc_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-s390', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-s390 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-s390_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-s390-tape', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-s390-tape is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-s390-tape_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-s390x', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-s390x_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-s3c2410', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-s3c2410 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-s3c2410_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-sb1-bcm91250a', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-sb1-bcm91250a is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-sb1-bcm91250a_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-sb1a-bcm91480b', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-sb1a-bcm91480b is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-sb1a-bcm91480b_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-sparc32', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-sparc32 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-sparc32_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-sparc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-sparc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-sparc64-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-sparc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-sparc64-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-vserver-686', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-vserver-686_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-vserver-alpha', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-vserver-alpha is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-vserver-alpha_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-vserver-amd64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-vserver-amd64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-vserver-amd64-k8-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-vserver-amd64-k8-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-vserver-amd64-k8-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-vserver-em64t-p4-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-vserver-em64t-p4-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-vserver-em64t-p4-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-vserver-k7', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-vserver-k7_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-vserver-powerpc', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-vserver-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-vserver-powerpc_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-vserver-powerpc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-vserver-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-vserver-powerpc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-vserver-s390x', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-vserver-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-vserver-s390x_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-vserver-sparc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-vserver-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-vserver-sparc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-xen-686', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-xen-686_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-xen-amd64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-xen-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-xen-amd64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-xen-vserver-686', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-xen-vserver-686_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6-xen-vserver-amd64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6-xen-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6-xen-vserver-amd64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-486', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-486 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-486_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-686', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-686_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-686-bigmem', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-686-bigmem_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-alpha-generic', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-alpha-generic is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-alpha-generic_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-alpha-legacy', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-alpha-legacy is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-alpha-legacy_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-alpha-smp', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-alpha-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-alpha-smp_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-amd64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-amd64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-footbridge', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-footbridge is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-footbridge_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-iop32x', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-iop32x is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-iop32x_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-itanium', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-itanium is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-itanium_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-ixp4xx', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-ixp4xx is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-ixp4xx_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-k7', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-k7_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-mckinley', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-mckinley is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-mckinley_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-parisc', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-parisc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-parisc_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-parisc-smp', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-parisc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-parisc-smp_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-parisc64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-parisc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-parisc64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-parisc64-smp', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-parisc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-parisc64-smp_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-powerpc', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-powerpc_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-powerpc-miboot', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-powerpc-miboot is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-powerpc-miboot_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-powerpc-smp', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-powerpc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-powerpc-smp_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-powerpc64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-powerpc64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-prep', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-prep is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-prep_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-qemu', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-qemu is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-qemu_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-r3k-kn02', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-r3k-kn02 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-r3k-kn02_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-r4k-ip22', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-r4k-ip22 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-r4k-ip22_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-r4k-kn04', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-r4k-kn04 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-r4k-kn04_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-r5k-cobalt', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-r5k-cobalt is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-r5k-cobalt_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-r5k-ip32', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-r5k-ip32 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-r5k-ip32_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-rpc', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-rpc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-rpc_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-s390', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-s390 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-s390_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-s390-tape', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-s390-tape is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-s390-tape_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-s390x', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-s390x_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-s3c2410', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-s3c2410 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-s3c2410_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-sb1-bcm91250a', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-sb1-bcm91250a is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-sb1-bcm91250a_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-sb1a-bcm91480b', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-sb1a-bcm91480b is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-sb1a-bcm91480b_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-sparc32', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-sparc32 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-sparc32_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-sparc64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-sparc64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-sparc64-smp', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-sparc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-sparc64-smp_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-686_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-alpha', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-alpha is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-alpha_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-amd64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-k7', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-k7_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-powerpc', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-powerpc_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-powerpc64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-powerpc64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-s390x', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-s390x_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-vserver-sparc64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-vserver-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-vserver-sparc64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-xen-686', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-xen-686_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-xen-amd64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-xen-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-xen-amd64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-xen-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-xen-vserver-686_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-6-xen-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-6-xen-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-6-xen-vserver-amd64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-image-486', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-486 is vulnerable in Debian 4.0.\nUpgrade to linux-image-486_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-686', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-686_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-686-bigmem', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to linux-image-686-bigmem_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-alpha-generic', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-alpha-generic is vulnerable in Debian 4.0.\nUpgrade to linux-image-alpha-generic_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-alpha-legacy', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-alpha-legacy is vulnerable in Debian 4.0.\nUpgrade to linux-image-alpha-legacy_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-alpha-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-alpha-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-alpha-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-amd64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-amd64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-footbridge', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-footbridge is vulnerable in Debian 4.0.\nUpgrade to linux-image-footbridge_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-iop32x', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-iop32x is vulnerable in Debian 4.0.\nUpgrade to linux-image-iop32x_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-itanium', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-itanium is vulnerable in Debian 4.0.\nUpgrade to linux-image-itanium_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-ixp4xx', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-ixp4xx is vulnerable in Debian 4.0.\nUpgrade to linux-image-ixp4xx_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-k7', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-image-k7_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-mckinley', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-mckinley is vulnerable in Debian 4.0.\nUpgrade to linux-image-mckinley_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-parisc', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-parisc is vulnerable in Debian 4.0.\nUpgrade to linux-image-parisc_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-parisc-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-parisc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-parisc-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-parisc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-parisc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-parisc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-parisc64-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-parisc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-parisc64-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-powerpc', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-image-powerpc_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-powerpc-miboot', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-powerpc-miboot is vulnerable in Debian 4.0.\nUpgrade to linux-image-powerpc-miboot_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-powerpc-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-powerpc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-powerpc-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-powerpc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-powerpc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-prep', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-prep is vulnerable in Debian 4.0.\nUpgrade to linux-image-prep_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-qemu', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-qemu is vulnerable in Debian 4.0.\nUpgrade to linux-image-qemu_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-r3k-kn02', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-r3k-kn02 is vulnerable in Debian 4.0.\nUpgrade to linux-image-r3k-kn02_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-r4k-ip22', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-r4k-ip22 is vulnerable in Debian 4.0.\nUpgrade to linux-image-r4k-ip22_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-r4k-kn04', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-r4k-kn04 is vulnerable in Debian 4.0.\nUpgrade to linux-image-r4k-kn04_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-r5k-cobalt', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-r5k-cobalt is vulnerable in Debian 4.0.\nUpgrade to linux-image-r5k-cobalt_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-r5k-ip32', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-r5k-ip32 is vulnerable in Debian 4.0.\nUpgrade to linux-image-r5k-ip32_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-rpc', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-rpc is vulnerable in Debian 4.0.\nUpgrade to linux-image-rpc_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-s390', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-s390 is vulnerable in Debian 4.0.\nUpgrade to linux-image-s390_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-s390-tape', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-s390-tape is vulnerable in Debian 4.0.\nUpgrade to linux-image-s390-tape_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-s390x', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-image-s390x_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-s3c2410', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-s3c2410 is vulnerable in Debian 4.0.\nUpgrade to linux-image-s3c2410_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-sb1-bcm91250a', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-sb1-bcm91250a is vulnerable in Debian 4.0.\nUpgrade to linux-image-sb1-bcm91250a_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-sb1a-bcm91480b', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-sb1a-bcm91480b is vulnerable in Debian 4.0.\nUpgrade to linux-image-sb1a-bcm91480b_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-sparc32', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-sparc32 is vulnerable in Debian 4.0.\nUpgrade to linux-image-sparc32_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-sparc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-sparc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-sparc64-smp', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-sparc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-sparc64-smp_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-vserver-686', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-vserver-686_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-vserver-alpha', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-vserver-alpha is vulnerable in Debian 4.0.\nUpgrade to linux-image-vserver-alpha_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-vserver-amd64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-vserver-amd64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-vserver-k7', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-image-vserver-k7_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-vserver-powerpc', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-vserver-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-image-vserver-powerpc_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-vserver-powerpc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-vserver-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-vserver-powerpc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-vserver-s390x', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-vserver-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-image-vserver-s390x_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-vserver-sparc64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-vserver-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-vserver-sparc64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-xen-686', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-xen-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-xen-686_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-xen-amd64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-xen-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-xen-amd64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-xen-vserver-686', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-xen-vserver-686_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-image-xen-vserver-amd64', release: '4.0', reference: '2.6.18+6etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-xen-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-xen-vserver-amd64_2.6.18+6etch3\n');
}
if (deb_check(prefix: 'linux-manual-2.6.18', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-manual-2.6.18 is vulnerable in Debian 4.0.\nUpgrade to linux-manual-2.6.18_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-modules-2.6.18-6-xen-686', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-modules-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to linux-modules-2.6.18-6-xen-686_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-modules-2.6.18-6-xen-amd64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-modules-2.6.18-6-xen-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-modules-2.6.18-6-xen-amd64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-modules-2.6.18-6-xen-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-modules-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-modules-2.6.18-6-xen-vserver-686_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-modules-2.6.18-6-xen-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-modules-2.6.18-6-xen-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-modules-2.6.18-6-xen-vserver-amd64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-patch-debian-2.6.18', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-patch-debian-2.6.18 is vulnerable in Debian 4.0.\nUpgrade to linux-patch-debian-2.6.18_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-source-2.6.18', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-source-2.6.18 is vulnerable in Debian 4.0.\nUpgrade to linux-source-2.6.18_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-support-2.6.18-6', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-support-2.6.18-6 is vulnerable in Debian 4.0.\nUpgrade to linux-support-2.6.18-6_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'linux-tree-2.6.18', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-tree-2.6.18 is vulnerable in Debian 4.0.\nUpgrade to linux-tree-2.6.18_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6-486', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6-486 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6-486_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6-686', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6-686 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6-686_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6-686-bigmem', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6-686-bigmem_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6-amd64', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6-amd64 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6-amd64_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6-k7', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6-k7 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6-k7_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6-vserver-686', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6-vserver-686_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6-vserver-k7', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6-vserver-k7_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6-xen-686', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6-xen-686_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6-xen-vserver-686', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6-xen-vserver-686_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6.18-6-486', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6.18-6-486 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6.18-6-486_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6.18-6-686', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6.18-6-686 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6.18-6-686_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6.18-6-686-bigmem', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6.18-6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6.18-6-686-bigmem_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6.18-6-amd64', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6.18-6-amd64 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6.18-6-amd64_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6.18-6-k7', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6.18-6-k7 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6.18-6-k7_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6.18-6-vserver-686', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6.18-6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6.18-6-vserver-686_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6.18-6-vserver-k7', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6.18-6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6.18-6-vserver-k7_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6.18-6-xen-686', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6.18-6-xen-686_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-modules-2.6.18-6-xen-vserver-686', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-modules-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to loop-aes-modules-2.6.18-6-xen-vserver-686_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-source', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-source is vulnerable in Debian 4.0.\nUpgrade to loop-aes-source_3.1d-13etch2\n');
}
if (deb_check(prefix: 'loop-aes-testsuite', release: '4.0', reference: '3.1d-13etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package loop-aes-testsuite is vulnerable in Debian 4.0.\nUpgrade to loop-aes-testsuite_3.1d-13etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-2.6-486', release: '4.0', reference: '1.0.8776+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-2.6-486 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-2.6-486_1.0.8776+6etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-2.6-686', release: '4.0', reference: '1.0.8776+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-2.6-686 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-2.6-686_1.0.8776+6etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-2.6-amd64', release: '4.0', reference: '1.0.8776+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-2.6-amd64 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-2.6-amd64_1.0.8776+6etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-2.6-k7', release: '4.0', reference: '1.0.8776+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-2.6-k7 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-2.6-k7_1.0.8776+6etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-2.6.18-6-486', release: '4.0', reference: '1.0.8776+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-2.6.18-6-486 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-2.6.18-6-486_1.0.8776+6etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-2.6.18-6-686', release: '4.0', reference: '1.0.8776+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-2.6.18-6-686 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-2.6.18-6-686_1.0.8776+6etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-2.6.18-6-amd64', release: '4.0', reference: '1.0.8776+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-2.6.18-6-amd64 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-2.6.18-6-amd64_1.0.8776+6etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-2.6.18-6-k7', release: '4.0', reference: '1.0.8776+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-2.6.18-6-k7 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-2.6.18-6-k7_1.0.8776+6etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-legacy-2.6-486', release: '4.0', reference: '1.0.7184+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-legacy-2.6-486 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-legacy-2.6-486_1.0.7184+6etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-legacy-2.6-686', release: '4.0', reference: '1.0.7184+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-legacy-2.6-686 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-legacy-2.6-686_1.0.7184+6etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-legacy-2.6-amd64', release: '4.0', reference: '1.0.7184+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-legacy-2.6-amd64 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-legacy-2.6-amd64_1.0.7184+6etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-legacy-2.6-k7', release: '4.0', reference: '1.0.7184+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-legacy-2.6-k7 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-legacy-2.6-k7_1.0.7184+6etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-legacy-2.6.18-6-486', release: '4.0', reference: '1.0.7184+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-legacy-2.6.18-6-486 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-legacy-2.6.18-6-486_1.0.7184+6etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-legacy-2.6.18-6-686', release: '4.0', reference: '1.0.7184+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-legacy-2.6.18-6-686 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-legacy-2.6.18-6-686_1.0.7184+6etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-legacy-2.6.18-6-amd64', release: '4.0', reference: '1.0.7184+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-legacy-2.6.18-6-amd64 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-legacy-2.6.18-6-amd64_1.0.7184+6etch2\n');
}
if (deb_check(prefix: 'nvidia-kernel-legacy-2.6.18-6-k7', release: '4.0', reference: '1.0.7184+6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nvidia-kernel-legacy-2.6.18-6-k7 is vulnerable in Debian 4.0.\nUpgrade to nvidia-kernel-legacy-2.6.18-6-k7_1.0.7184+6etch2\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6-486', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6-486 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6-486_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6-686', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6-686 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6-686_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6-686-bigmem', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6-686-bigmem_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6-amd64', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6-amd64 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6-amd64_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6-k7', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6-k7 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6-k7_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6-vserver-686', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6-vserver-686_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6-vserver-k7', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6-vserver-k7_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6-xen-686', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6-xen-686_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6-xen-vserver-686', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6-xen-vserver-686_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6.18-6-486', release: '4.0', reference: '2.6.18+1.03.00-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6.18-6-486 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6.18-6-486_2.6.18+1.03.00-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6.18-6-686', release: '4.0', reference: '2.6.18+1.03.00-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6.18-6-686 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6.18-6-686_2.6.18+1.03.00-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6.18-6-686-bigmem', release: '4.0', reference: '2.6.18+1.03.00-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6.18-6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6.18-6-686-bigmem_2.6.18+1.03.00-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6.18-6-amd64', release: '4.0', reference: '2.6.18+1.03.00-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6.18-6-amd64 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6.18-6-amd64_2.6.18+1.03.00-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6.18-6-k7', release: '4.0', reference: '2.6.18+1.03.00-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6.18-6-k7 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6.18-6-k7_2.6.18+1.03.00-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6.18-6-vserver-686', release: '4.0', reference: '2.6.18+1.03.00-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6.18-6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6.18-6-vserver-686_2.6.18+1.03.00-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6.18-6-vserver-k7', release: '4.0', reference: '2.6.18+1.03.00-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6.18-6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6.18-6-vserver-k7_2.6.18+1.03.00-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6.18-6-xen-686', release: '4.0', reference: '2.6.18+1.03.00-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6.18-6-xen-686_2.6.18+1.03.00-7+etch4\n');
}
if (deb_check(prefix: 'redhat-cluster-modules-2.6.18-6-xen-vserver-686', release: '4.0', reference: '2.6.18+1.03.00-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package redhat-cluster-modules-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to redhat-cluster-modules-2.6.18-6-xen-vserver-686_2.6.18+1.03.00-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6-486', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6-486 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6-486_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6-686', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6-686 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6-686_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6-686-bigmem', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6-686-bigmem_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6-amd64', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6-amd64 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6-amd64_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6-k7', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6-k7 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6-k7_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6-vserver-686', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6-vserver-686_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6-vserver-k7', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6-vserver-k7_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6-xen-686', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6-xen-686_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6-xen-vserver-686', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6-xen-vserver-686_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6.18-6-486', release: '4.0', reference: '2.6.18+3.1r2-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6.18-6-486 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6.18-6-486_2.6.18+3.1r2-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6.18-6-686', release: '4.0', reference: '2.6.18+3.1r2-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6.18-6-686 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6.18-6-686_2.6.18+3.1r2-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6.18-6-686-bigmem', release: '4.0', reference: '2.6.18+3.1r2-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6.18-6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6.18-6-686-bigmem_2.6.18+3.1r2-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6.18-6-amd64', release: '4.0', reference: '2.6.18+3.1r2-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6.18-6-amd64 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6.18-6-amd64_2.6.18+3.1r2-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6.18-6-k7', release: '4.0', reference: '2.6.18+3.1r2-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6.18-6-k7 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6.18-6-k7_2.6.18+3.1r2-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6.18-6-vserver-686', release: '4.0', reference: '2.6.18+3.1r2-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6.18-6-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6.18-6-vserver-686_2.6.18+3.1r2-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6.18-6-vserver-k7', release: '4.0', reference: '2.6.18+3.1r2-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6.18-6-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6.18-6-vserver-k7_2.6.18+3.1r2-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6.18-6-xen-686', release: '4.0', reference: '2.6.18+3.1r2-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6.18-6-xen-686_2.6.18+3.1r2-7+etch4\n');
}
if (deb_check(prefix: 'squashfs-modules-2.6.18-6-xen-vserver-686', release: '4.0', reference: '2.6.18+3.1r2-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squashfs-modules-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to squashfs-modules-2.6.18-6-xen-vserver-686_2.6.18+3.1r2-7+etch4\n');
}
if (deb_check(prefix: 'unionfs-modules-2.6-486', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package unionfs-modules-2.6-486 is vulnerable in Debian 4.0.\nUpgrade to unionfs-modules-2.6-486_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'unionfs-modules-2.6-686', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package unionfs-modules-2.6-686 is vulnerable in Debian 4.0.\nUpgrade to unionfs-modules-2.6-686_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'unionfs-modules-2.6-686-bigmem', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package unionfs-modules-2.6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to unionfs-modules-2.6-686-bigmem_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'unionfs-modules-2.6-amd64', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package unionfs-modules-2.6-amd64 is vulnerable in Debian 4.0.\nUpgrade to unionfs-modules-2.6-amd64_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'unionfs-modules-2.6-k7', release: '4.0', reference: '2.6.18-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package unionfs-modules-2.6-k7 is vulnerable in Debian 4.0.\nUpgrade to unionfs-modules-2.6-k7_2.6.18-7+etch4\n');
}
if (deb_check(prefix: 'unionfs-modules-2.6.18-6-486', release: '4.0', reference: '2.6.18+1.4+debian-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package unionfs-modules-2.6.18-6-486 is vulnerable in Debian 4.0.\nUpgrade to unionfs-modules-2.6.18-6-486_2.6.18+1.4+debian-7+etch4\n');
}
if (deb_check(prefix: 'unionfs-modules-2.6.18-6-686', release: '4.0', reference: '2.6.18+1.4+debian-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package unionfs-modules-2.6.18-6-686 is vulnerable in Debian 4.0.\nUpgrade to unionfs-modules-2.6.18-6-686_2.6.18+1.4+debian-7+etch4\n');
}
if (deb_check(prefix: 'unionfs-modules-2.6.18-6-686-bigmem', release: '4.0', reference: '2.6.18+1.4+debian-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package unionfs-modules-2.6.18-6-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to unionfs-modules-2.6.18-6-686-bigmem_2.6.18+1.4+debian-7+etch4\n');
}
if (deb_check(prefix: 'unionfs-modules-2.6.18-6-amd64', release: '4.0', reference: '2.6.18+1.4+debian-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package unionfs-modules-2.6.18-6-amd64 is vulnerable in Debian 4.0.\nUpgrade to unionfs-modules-2.6.18-6-amd64_2.6.18+1.4+debian-7+etch4\n');
}
if (deb_check(prefix: 'unionfs-modules-2.6.18-6-k7', release: '4.0', reference: '2.6.18+1.4+debian-7+etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package unionfs-modules-2.6.18-6-k7 is vulnerable in Debian 4.0.\nUpgrade to unionfs-modules-2.6.18-6-k7_2.6.18+1.4+debian-7+etch4\n');
}
if (deb_check(prefix: 'user-mode-linux', release: '4.0', reference: '2.6.18-1um-2etch.17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package user-mode-linux is vulnerable in Debian 4.0.\nUpgrade to user-mode-linux_2.6.18-1um-2etch.17etch1\n');
}
if (deb_check(prefix: 'xen-linux-system-2.6.18-6-xen-686', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-linux-system-2.6.18-6-xen-686 is vulnerable in Debian 4.0.\nUpgrade to xen-linux-system-2.6.18-6-xen-686_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'xen-linux-system-2.6.18-6-xen-amd64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-linux-system-2.6.18-6-xen-amd64 is vulnerable in Debian 4.0.\nUpgrade to xen-linux-system-2.6.18-6-xen-amd64_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'xen-linux-system-2.6.18-6-xen-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-linux-system-2.6.18-6-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to xen-linux-system-2.6.18-6-xen-vserver-686_2.6.18.dfsg.1-17etch1\n');
}
if (deb_check(prefix: 'xen-linux-system-2.6.18-6-xen-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-17etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-linux-system-2.6.18-6-xen-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to xen-linux-system-2.6.18-6-xen-vserver-amd64_2.6.18.dfsg.1-17etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
