# This script was automatically generated from the dsa-1483
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
The SNMP agent (snmp_agent.c) in net-snmp before 5.4.1 allows remote
attackers to cause a denial of service (CPU and memory consumption)
via a GETBULK request with a large max-repeaters value.
For the stable distribution (etch), this problem has been fixed in
version 5.2.3-7etch2.
For the unstable and testing distributions (sid and lenny,
respectively), this problem has been fixed in version 5.4.1~dfsg-2.
We recommend that you upgrade your net-snmp package.


Solution : http://www.debian.org/security/2008/dsa-1483
Risk factor : High';

if (description) {
 script_id(30223);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1483");
 script_cve_id("CVE-2007-5846");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1483] DSA-1483-1 net-snmp");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1483-1 net-snmp");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libsnmp-base', release: '4.0', reference: '5.2.3-7etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsnmp-base is vulnerable in Debian 4.0.\nUpgrade to libsnmp-base_5.2.3-7etch2\n');
}
if (deb_check(prefix: 'libsnmp-perl', release: '4.0', reference: '5.2.3-7etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsnmp-perl is vulnerable in Debian 4.0.\nUpgrade to libsnmp-perl_5.2.3-7etch2\n');
}
if (deb_check(prefix: 'libsnmp9', release: '4.0', reference: '5.2.3-7etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsnmp9 is vulnerable in Debian 4.0.\nUpgrade to libsnmp9_5.2.3-7etch2\n');
}
if (deb_check(prefix: 'libsnmp9-dev', release: '4.0', reference: '5.2.3-7etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsnmp9-dev is vulnerable in Debian 4.0.\nUpgrade to libsnmp9-dev_5.2.3-7etch2\n');
}
if (deb_check(prefix: 'snmp', release: '4.0', reference: '5.2.3-7etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package snmp is vulnerable in Debian 4.0.\nUpgrade to snmp_5.2.3-7etch2\n');
}
if (deb_check(prefix: 'snmpd', release: '4.0', reference: '5.2.3-7etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package snmpd is vulnerable in Debian 4.0.\nUpgrade to snmpd_5.2.3-7etch2\n');
}
if (deb_check(prefix: 'tkmib', release: '4.0', reference: '5.2.3-7etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tkmib is vulnerable in Debian 4.0.\nUpgrade to tkmib_5.2.3-7etch2\n');
}
if (deb_check(prefix: 'net-snmp', release: '4.0', reference: '5.2.3-7etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package net-snmp is vulnerable in Debian etch.\nUpgrade to net-snmp_5.2.3-7etch2\n');
}
if (w) { security_hole(port: 0, data: desc); }
