# This script was automatically generated from the dsa-1487
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several vulnerabilities have been discovered in the EXIF parsing code
of the libexif library, which can lead to denial of service or the 
execution of arbitrary code if a user is tricked into opening a
malformed image.
    Victor Stinner discovered an integer overflow, which may result in
    denial of service or potentially the execution of arbitrary code.
    Meder Kydyraliev discovered an infinite loop, which may result in
    denial of service.
    Victor Stinner discovered an integer overflow, which may result
    in denial of service or potentially the execution of arbitrary
    code.
This update also fixes two potential NULL pointer deferences.
For the old stable distribution (sarge), these problems have been
fixed in 0.6.9-6sarge2.
For the stable distribution (etch), these problems have been fixed in
version 0.6.13-5etch2.
We recommend that you upgrade your libexif packages.


Solution : http://www.debian.org/security/2008/dsa-1487
Risk factor : High';

if (description) {
 script_id(30226);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1487");
 script_cve_id("CVE-2007-2645", "CVE-2007-6351", "CVE-2007-6352");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1487] DSA-1487-1 libexif");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1487-1 libexif");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libexif-dev', release: '3.1', reference: '0.6.9-6sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libexif-dev is vulnerable in Debian 3.1.\nUpgrade to libexif-dev_0.6.9-6sarge2\n');
}
if (deb_check(prefix: 'libexif10', release: '3.1', reference: '0.6.9-6sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libexif10 is vulnerable in Debian 3.1.\nUpgrade to libexif10_0.6.9-6sarge2\n');
}
if (deb_check(prefix: 'libexif-dev', release: '4.0', reference: '0.6.13-5etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libexif-dev is vulnerable in Debian 4.0.\nUpgrade to libexif-dev_0.6.13-5etch2\n');
}
if (deb_check(prefix: 'libexif12', release: '4.0', reference: '0.6.13-5etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libexif12 is vulnerable in Debian 4.0.\nUpgrade to libexif12_0.6.13-5etch2\n');
}
if (deb_check(prefix: 'libexif', release: '4.0', reference: '0.6.13-5etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libexif is vulnerable in Debian etch.\nUpgrade to libexif_0.6.13-5etch2\n');
}
if (w) { security_hole(port: 0, data: desc); }
