# This script was automatically generated from the dsa-1489
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Iceweasel
web browser, an unbranded version of the Firefox browser. The Common
Vulnerabilities and Exposures project identifies the following problems:
    Jesse Ruderman, Kai Engert, Martijn Wargers, Mats Palmgren and Paul
    Nickerson discovered crashes in the layout engine, which might allow
    the execution of arbitrary code.
    Carsten Book, Wesley Garland, Igor Bukanov, <q>moz_bug_r_a4</q>, <q>shutdown</q>,
    Philip Taylor and <q>tgirmann</q> discovered crashes in the Javascript
    engine, which might allow the execution of arbitrary code.
    <q>hong</q> and Gregory Fleisher discovered that file input focus
    vulnerabilities in the file upload control could allow information
    disclosure of local files.
    <q>moz_bug_r_a4</q> and Boris Zbarsky discovered several
    vulnerabilities in Javascript handling, which could allow
    privilege escalation.
    Justin Dolske discovered that the password storage mechanism could
    be abused by malicious web sites to corrupt existing saved passwords.
    Gerry Eisenhaur and <q>moz_bug_r_a4</q> discovered that a directory
    traversal vulnerability in chrome: URI handling could lead to
    information disclosure.
    David Bloom discovered a race condition in the image handling of
    designMode elements, which can lead to information disclosure or
    potentially the execution of arbitrary code.
    Michal Zalewski discovered that timers protecting security-sensitive
    dialogs (which disable dialog elements until a timeout is reached)
    could be bypassed by window focus changes through Javascript.
    It was discovered that malformed content declarations of saved
    attachments could prevent a user in the opening local files
    with a <q>.txt</q> file name, resulting in minor denial of service.
    Martin Straka discovered that insecure stylesheet handling during
    redirects could lead to information disclosure.
    Emil Ljungdahl and Lars-Olof Moilanen discovered that phishing
    protections could be bypassed with <div> elements.
The Mozilla products from the old stable distribution (sarge) are no
longer supported with security updates.
For the stable distribution (etch), these problems have been fixed in
version 2.0.0.12-0etch1.
We recommend that you upgrade your iceweasel packages.


Solution : http://www.debian.org/security/2008/dsa-1489
Risk factor : High';

if (description) {
 script_id(30228);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1489");
 script_cve_id("CVE-2008-0412", "CVE-2008-0413", "CVE-2008-0414", "CVE-2008-0415", "CVE-2008-0416", "CVE-2008-0417", "CVE-2008-0418");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1489] DSA-1489-1 iceweasel");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1489-1 iceweasel");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'firefox', release: '4.0', reference: '2.0.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package firefox is vulnerable in Debian 4.0.\nUpgrade to firefox_2.0.0.12-0etch1\n');
}
if (deb_check(prefix: 'firefox-dom-inspector', release: '4.0', reference: '2.0.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package firefox-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to firefox-dom-inspector_2.0.0.12-0etch1\n');
}
if (deb_check(prefix: 'firefox-gnome-support', release: '4.0', reference: '2.0.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package firefox-gnome-support is vulnerable in Debian 4.0.\nUpgrade to firefox-gnome-support_2.0.0.12-0etch1\n');
}
if (deb_check(prefix: 'iceweasel', release: '4.0', reference: '2.0.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel is vulnerable in Debian 4.0.\nUpgrade to iceweasel_2.0.0.12-0etch1\n');
}
if (deb_check(prefix: 'iceweasel-dbg', release: '4.0', reference: '2.0.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel-dbg is vulnerable in Debian 4.0.\nUpgrade to iceweasel-dbg_2.0.0.12-0etch1\n');
}
if (deb_check(prefix: 'iceweasel-dom-inspector', release: '4.0', reference: '2.0.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to iceweasel-dom-inspector_2.0.0.12-0etch1\n');
}
if (deb_check(prefix: 'iceweasel-gnome-support', release: '4.0', reference: '2.0.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel-gnome-support is vulnerable in Debian 4.0.\nUpgrade to iceweasel-gnome-support_2.0.0.12-0etch1\n');
}
if (deb_check(prefix: 'mozilla-firefox', release: '4.0', reference: '2.0.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox is vulnerable in Debian 4.0.\nUpgrade to mozilla-firefox_2.0.0.12-0etch1\n');
}
if (deb_check(prefix: 'mozilla-firefox-dom-inspector', release: '4.0', reference: '2.0.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to mozilla-firefox-dom-inspector_2.0.0.12-0etch1\n');
}
if (deb_check(prefix: 'mozilla-firefox-gnome-support', release: '4.0', reference: '2.0.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-gnome-support is vulnerable in Debian 4.0.\nUpgrade to mozilla-firefox-gnome-support_2.0.0.12-0etch1\n');
}
if (deb_check(prefix: 'iceweasel', release: '4.0', reference: '2.0.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel is vulnerable in Debian etch.\nUpgrade to iceweasel_2.0.0.12-0etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
