# This script was automatically generated from the dsa-1490
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that a buffer overflow in the GIF image parsing code
of Tk, a cross-platform graphical toolkit, could lead to a denial of
service and potentially the execution of arbitrary code.
For the old stable distribution (sarge), this problem has been fixed in
version 8.3.5-4sarge1.
For the stable distribution (etch), this problem has been fixed in
version 8.3.5-6etch2.
We recommend that you upgrade your tk8.3 packages.


Solution : http://www.debian.org/security/2008/dsa-1490
Risk factor : High';

if (description) {
 script_id(30229);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1490");
 script_cve_id("CVE-2008-0553");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1490] DSA-1490-1 tk8.3");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1490-1 tk8.3");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'tk8.3', release: '3.1', reference: '8.3.5-4sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tk8.3 is vulnerable in Debian 3.1.\nUpgrade to tk8.3_8.3.5-4sarge1\n');
}
if (deb_check(prefix: 'tk8.3-dev', release: '3.1', reference: '8.3.5-4sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tk8.3-dev is vulnerable in Debian 3.1.\nUpgrade to tk8.3-dev_8.3.5-4sarge1\n');
}
if (deb_check(prefix: 'tk8.3-doc', release: '3.1', reference: '8.3.5-4sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tk8.3-doc is vulnerable in Debian 3.1.\nUpgrade to tk8.3-doc_8.3.5-4sarge1\n');
}
if (deb_check(prefix: 'tk8.3', release: '4.0', reference: '8.3.5-6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tk8.3 is vulnerable in Debian 4.0.\nUpgrade to tk8.3_8.3.5-6etch2\n');
}
if (deb_check(prefix: 'tk8.3-dev', release: '4.0', reference: '8.3.5-6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tk8.3-dev is vulnerable in Debian 4.0.\nUpgrade to tk8.3-dev_8.3.5-6etch2\n');
}
if (deb_check(prefix: 'tk8.3-doc', release: '4.0', reference: '8.3.5-6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tk8.3-doc is vulnerable in Debian 4.0.\nUpgrade to tk8.3-doc_8.3.5-6etch2\n');
}
if (deb_check(prefix: 'tk8.3', release: '4.0', reference: '8.3.5-6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tk8.3 is vulnerable in Debian etch.\nUpgrade to tk8.3_8.3.5-6etch2\n');
}
if (deb_check(prefix: 'tk8.3', release: '3.1', reference: '8.3.5-4sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tk8.3 is vulnerable in Debian sarge.\nUpgrade to tk8.3_8.3.5-4sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
