# This script was automatically generated from the dsa-1501
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Tobias Gruetzmacher discovered that a Debian-provided CRON script in dspam,
a statistical spam filter, included a database password on the command line.
This allowed a local attacker to read the contents of the dspam database,
such as emails.
For the stable distribution (etch), this problem has been fixed in version
3.6.8-5etch1.
The old stable distribution (sarge) does not contain the dspam package.
For the unstable distribution (sid), this problem has been fixed in version
3.6.8-5.1.
We recommend that you upgrade your dspam package.


Solution : http://www.debian.org/security/2008/dsa-1501
Risk factor : High';

if (description) {
 script_id(31145);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1501");
 script_cve_id("CVE-2007-6418");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1501] DSA-1501-1 dspam");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1501-1 dspam");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'dspam', release: '4.0', reference: '3.6.8-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dspam is vulnerable in Debian 4.0.\nUpgrade to dspam_3.6.8-5etch1\n');
}
if (deb_check(prefix: 'dspam-doc', release: '4.0', reference: '3.6.8-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dspam-doc is vulnerable in Debian 4.0.\nUpgrade to dspam-doc_3.6.8-5etch1\n');
}
if (deb_check(prefix: 'dspam-webfrontend', release: '4.0', reference: '3.6.8-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dspam-webfrontend is vulnerable in Debian 4.0.\nUpgrade to dspam-webfrontend_3.6.8-5etch1\n');
}
if (deb_check(prefix: 'libdspam7', release: '4.0', reference: '3.6.8-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libdspam7 is vulnerable in Debian 4.0.\nUpgrade to libdspam7_3.6.8-5etch1\n');
}
if (deb_check(prefix: 'libdspam7-dev', release: '4.0', reference: '3.6.8-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libdspam7-dev is vulnerable in Debian 4.0.\nUpgrade to libdspam7-dev_3.6.8-5etch1\n');
}
if (deb_check(prefix: 'libdspam7-drv-db4', release: '4.0', reference: '3.6.8-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libdspam7-drv-db4 is vulnerable in Debian 4.0.\nUpgrade to libdspam7-drv-db4_3.6.8-5etch1\n');
}
if (deb_check(prefix: 'libdspam7-drv-mysql', release: '4.0', reference: '3.6.8-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libdspam7-drv-mysql is vulnerable in Debian 4.0.\nUpgrade to libdspam7-drv-mysql_3.6.8-5etch1\n');
}
if (deb_check(prefix: 'libdspam7-drv-pgsql', release: '4.0', reference: '3.6.8-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libdspam7-drv-pgsql is vulnerable in Debian 4.0.\nUpgrade to libdspam7-drv-pgsql_3.6.8-5etch1\n');
}
if (deb_check(prefix: 'libdspam7-drv-sqlite3', release: '4.0', reference: '3.6.8-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libdspam7-drv-sqlite3 is vulnerable in Debian 4.0.\nUpgrade to libdspam7-drv-sqlite3_3.6.8-5etch1\n');
}
if (deb_check(prefix: 'dspam', release: '4.0', reference: '3.6.8-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dspam is vulnerable in Debian etch.\nUpgrade to dspam_3.6.8-5etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
