# This script was automatically generated from the dsa-1502
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Several remote vulnerabilities have been discovered in wordpress, a weblog
manager. The Common Vulnerabilities and Exposures project identifies the following
problems:
    Cross-site scripting (XSS) vulnerability in functions.php in the default 
    theme in WordPress allows remote authenticated administrators to inject 
    arbitrary web script or HTML via the PATH_INFO (REQUEST_URI) to 
    wp-admin/themes.php.
    SQL injection vulnerability in wp-admin/admin-ajax.php in WordPress 
    before 2.2 allows remote attackers to execute arbitrary SQL commands via 
    the cookie parameter.
    Cross-site scripting (XSS) vulnerability in wp-db-backup.php in 
    WordPress 2.0.11 and earlier allows remote attackers to inject 
    arbitrary web script or HTML via the backup parameter in a 
    wp-db-backup.php action to wp-admin/edit.php.
    Directory traversal vulnerability in wp-db-backup.php in WordPress 2.0.3 
    and earlier allows remote attackers to read arbitrary files, delete 
    arbitrary files, and cause a denial of service via a .. (dot dot) in the 
    backup parameter in a wp-db-backup.php action to wp-admin/edit.php.
For the stable distribution (etch), these problems have been fixed in version
2.0.10-1etch1.  Wordpress is not present in the oldstable distribution (sarge).
We recommend that you upgrade your wordpress package.


Solution : http://www.debian.org/security/2008/dsa-1502
Risk factor : High';

if (description) {
 script_id(31146);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1502");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1502] DSA-1502-1 wordpress");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1502-1 wordpress");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'wordpress', release: '4.0', reference: '2.0.10-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wordpress is vulnerable in Debian 4.0.\nUpgrade to wordpress_2.0.10-1etch1\n');
}
if (deb_check(prefix: 'wordpress', release: '4.0', reference: '2.0.10-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package wordpress is vulnerable in Debian etch.\nUpgrade to wordpress_2.0.10-1etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
