# This script was automatically generated from the dsa-1503
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several local and remote vulnerabilities have been discovered in the Linux
kernel that may lead to a denial of service or the execution of arbitrary
code.  The Common Vulnerabilities and Exposures project identifies the
following problems:
    infamous41md reported multiple integer overflows in the Sbus PROM
    driver that would allow for a DoS (Denial of Service) attack by a
    local user, and possibly the execution of arbitrary code.
    Doug Chapman discovered a potential local DoS (deadlock) in the mincore
    function caused by improper lock handling.
    Eric Sandeen provided a fix for a local memory corruption vulnerability
    resulting from a misinterpretation of return values when operating on
    inodes which have been marked bad.
    LMH reported a potential local DoS which could be exploited by a malicious
    user with the privileges to mount and read a corrupted cramfs filesystem.
    LMH reported a potential local DoS which could be exploited by a malicious
    user with the privileges to mount and read a corrupted ext3 filesystem.
    LMH reported a potential local DoS which could be exploited by a malicious
    user with the privileges to mount and read a corrupted ext2 filesystem.
    Marcel Holtman discovered multiple buffer overflows in the Bluetooth
    subsystem which can be used to trigger a remote DoS (crash) and potentially
    execute arbitrary code.
    Ilja van Sprundel discovered that kernel memory could be leaked via the
    Bluetooth setsockopt call due to an uninitialized stack buffer. This
    could be used by local attackers to read the contents of sensitive kernel
    memory.
    Masayuki Nakagawa discovered that flow labels were inadvertently
    being shared between listening sockets and child sockets. This defect
    can be exploited by local users to cause a DoS (Oops).
    Thomas Graf reported a typo in the DECnet protocol handler that could
    be used by a local attacker to overrun an array via crafted packets,
    potentially resulting in a Denial of Service (system crash).
    A similar issue exists in the IPV4 protocol handler and will be fixed
    in a subsequent update.
    Florian Zumbiehl discovered a memory leak in the PPPOE subsystem caused
    by releasing a socket before PPPIOCGCHAN is called upon it. This could
    be used by a local user to DoS a system by consuming all available memory.
    Wojciech Purczynski discovered that pdeath_signal was not being reset
    properly under certain conditions which may allow local users to gain
    privileges by sending arbitrary signals to suid binaries.
    Alan Cox reported an issue in the aacraid driver that allows unprivileged
    local users to make ioctl calls which should be restricted to admin
    privileges.
    PaX team discovered an issue in the random driver where a defect in the
    reseeding code leads to a reduction in entropy.
    Alex Smith discovered an issue with the pwc driver for certain webcam
    devices. If the device is removed while a userspace application has it
    open, the driver will wait for userspace to close the d
[...]

Solution : http://www.debian.org/security/2008/dsa-1503
Risk factor : High';

if (description) {
 script_id(31147);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1503");
 script_cve_id("CVE-2004-2731", "CVE-2006-4814", "CVE-2006-5753", "CVE-2006-5823", "CVE-2006-6053", "CVE-2006-6054", "CVE-2006-6106");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1503] DSA-1503-1 kernel-source-2.4.27");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1503-1 kernel-source-2.4.27");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'hostap-modules-2.4.27-4-386', release: '3.1', reference: '0.3.7-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.4.27-4-386 is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.4.27-4-386_0.3.7-1sarge3\n');
}
if (deb_check(prefix: 'hostap-modules-2.4.27-4-586tsc', release: '3.1', reference: '0.3.7-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.4.27-4-586tsc is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.4.27-4-586tsc_0.3.7-1sarge3\n');
}
if (deb_check(prefix: 'hostap-modules-2.4.27-4-686', release: '3.1', reference: '0.3.7-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.4.27-4-686 is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.4.27-4-686_0.3.7-1sarge3\n');
}
if (deb_check(prefix: 'hostap-modules-2.4.27-4-686-smp', release: '3.1', reference: '0.3.7-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.4.27-4-686-smp is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.4.27-4-686-smp_0.3.7-1sarge3\n');
}
if (deb_check(prefix: 'hostap-modules-2.4.27-4-k6', release: '3.1', reference: '0.3.7-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.4.27-4-k6 is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.4.27-4-k6_0.3.7-1sarge3\n');
}
if (deb_check(prefix: 'hostap-modules-2.4.27-4-k7', release: '3.1', reference: '0.3.7-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.4.27-4-k7 is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.4.27-4-k7_0.3.7-1sarge3\n');
}
if (deb_check(prefix: 'hostap-modules-2.4.27-4-k7-smp', release: '3.1', reference: '0.3.7-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.4.27-4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.4.27-4-k7-smp_0.3.7-1sarge3\n');
}
if (deb_check(prefix: 'hostap-modules-2.6.8-4-386', release: '3.1', reference: '0.3.7-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.6.8-4-386 is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.6.8-4-386_0.3.7-1sarge3\n');
}
if (deb_check(prefix: 'hostap-modules-2.6.8-4-686', release: '3.1', reference: '0.3.7-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.6.8-4-686 is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.6.8-4-686_0.3.7-1sarge3\n');
}
if (deb_check(prefix: 'hostap-modules-2.6.8-4-686-smp', release: '3.1', reference: '0.3.7-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.6.8-4-686-smp is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.6.8-4-686-smp_0.3.7-1sarge3\n');
}
if (deb_check(prefix: 'hostap-modules-2.6.8-4-k7', release: '3.1', reference: '0.3.7-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.6.8-4-k7 is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.6.8-4-k7_0.3.7-1sarge3\n');
}
if (deb_check(prefix: 'hostap-modules-2.6.8-4-k7-smp', release: '3.1', reference: '0.3.7-1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.6.8-4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.6.8-4-k7-smp_0.3.7-1sarge3\n');
}
if (deb_check(prefix: 'i2c-2.4.27-4-386', release: '3.1', reference: '2.9.1-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package i2c-2.4.27-4-386 is vulnerable in Debian 3.1.\nUpgrade to i2c-2.4.27-4-386_2.9.1-1sarge2\n');
}
if (deb_check(prefix: 'i2c-2.4.27-4-586tsc', release: '3.1', reference: '2.9.1-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package i2c-2.4.27-4-586tsc is vulnerable in Debian 3.1.\nUpgrade to i2c-2.4.27-4-586tsc_2.9.1-1sarge2\n');
}
if (deb_check(prefix: 'i2c-2.4.27-4-686', release: '3.1', reference: '2.9.1-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package i2c-2.4.27-4-686 is vulnerable in Debian 3.1.\nUpgrade to i2c-2.4.27-4-686_2.9.1-1sarge2\n');
}
if (deb_check(prefix: 'i2c-2.4.27-4-686-smp', release: '3.1', reference: '2.9.1-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package i2c-2.4.27-4-686-smp is vulnerable in Debian 3.1.\nUpgrade to i2c-2.4.27-4-686-smp_2.9.1-1sarge2\n');
}
if (deb_check(prefix: 'i2c-2.4.27-4-k6', release: '3.1', reference: '2.9.1-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package i2c-2.4.27-4-k6 is vulnerable in Debian 3.1.\nUpgrade to i2c-2.4.27-4-k6_2.9.1-1sarge2\n');
}
if (deb_check(prefix: 'i2c-2.4.27-4-k7', release: '3.1', reference: '2.9.1-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package i2c-2.4.27-4-k7 is vulnerable in Debian 3.1.\nUpgrade to i2c-2.4.27-4-k7_2.9.1-1sarge2\n');
}
if (deb_check(prefix: 'i2c-2.4.27-4-k7-smp', release: '3.1', reference: '2.9.1-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package i2c-2.4.27-4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to i2c-2.4.27-4-k7-smp_2.9.1-1sarge2\n');
}
if (deb_check(prefix: 'i2c-source', release: '3.1', reference: '2.9.1-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package i2c-source is vulnerable in Debian 3.1.\nUpgrade to i2c-source_2.9.1-1sarge2\n');
}
if (deb_check(prefix: 'kernel-build-2.4.27', release: '3.1', reference: '2.4.27-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.4.27 is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.4.27_2.4.27-2sarge6\n');
}
if (deb_check(prefix: 'kernel-build-2.4.27-4', release: '3.1', reference: '2.4.27-9sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.4.27-4 is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.4.27-4_2.4.27-9sarge6\n');
}
if (deb_check(prefix: 'kernel-build-2.4.27-apus', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.4.27-apus is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.4.27-apus_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-build-2.4.27-nubus', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.4.27-nubus is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.4.27-nubus_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-build-2.4.27-powerpc', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.4.27-powerpc is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.4.27-powerpc_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-build-2.4.27-powerpc-small', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.4.27-powerpc-small is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.4.27-powerpc-small_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-build-2.4.27-powerpc-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.4.27-powerpc-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.4.27-powerpc-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-doc-2.4.27', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-doc-2.4.27 is vulnerable in Debian 3.1.\nUpgrade to kernel-doc-2.4.27_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-doc-2.4.27-speakup', release: '3.1', reference: '2.4.27-1.1sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-doc-2.4.27-speakup is vulnerable in Debian 3.1.\nUpgrade to kernel-doc-2.4.27-speakup_2.4.27-1.1sarge5\n');
}
if (deb_check(prefix: 'kernel-headers-2.4-386', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4-386 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4-386_101sarge2\n');
}
if (deb_check(prefix: 'kernel-headers-2.4-586tsc', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4-586tsc is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4-586tsc_101sarge2\n');
}
if (deb_check(prefix: 'kernel-headers-2.4-686', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4-686 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4-686_101sarge2\n');
}
if (deb_check(prefix: 'kernel-headers-2.4-686-smp', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4-686-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4-686-smp_101sarge2\n');
}
if (deb_check(prefix: 'kernel-headers-2.4-generic', release: '3.1', reference: '101sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4-generic is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4-generic_101sarge3\n');
}
if (deb_check(prefix: 'kernel-headers-2.4-k6', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4-k6 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4-k6_101sarge2\n');
}
if (deb_check(prefix: 'kernel-headers-2.4-k7', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4-k7 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4-k7_101sarge2\n');
}
if (deb_check(prefix: 'kernel-headers-2.4-k7-smp', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4-k7-smp_101sarge2\n');
}
if (deb_check(prefix: 'kernel-headers-2.4-s390', release: '3.1', reference: '2.4.27-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4-s390 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4-s390_2.4.27-1sarge2\n');
}
if (deb_check(prefix: 'kernel-headers-2.4-smp', release: '3.1', reference: '101sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4-smp_101sarge3\n');
}
if (deb_check(prefix: 'kernel-headers-2.4-sparc32', release: '3.1', reference: '42sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4-sparc32 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4-sparc32_42sarge3\n');
}
if (deb_check(prefix: 'kernel-headers-2.4-sparc32-smp', release: '3.1', reference: '42sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4-sparc32-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4-sparc32-smp_42sarge3\n');
}
if (deb_check(prefix: 'kernel-headers-2.4-sparc64', release: '3.1', reference: '42sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4-sparc64 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4-sparc64_42sarge3\n');
}
if (deb_check(prefix: 'kernel-headers-2.4-sparc64-smp', release: '3.1', reference: '42sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4-sparc64-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4-sparc64-smp_42sarge3\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27', release: '3.1', reference: '2.4.27-10.sarge4.040815-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27_2.4.27-10.sarge4.040815-3\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4', release: '3.1', reference: '2.4.27-9sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4_2.4.27-9sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-386', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-386 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-386_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-586tsc', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-586tsc is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-586tsc_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-686', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-686 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-686_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-686-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-686-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-686-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-generic', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-generic is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-generic_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-itanium', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-itanium is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-itanium_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-itanium-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-itanium-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-itanium-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-k6', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-k6 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-k6_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-k7', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-k7 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-k7_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-k7-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-k7-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-mckinley', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-mckinley is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-mckinley_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-mckinley-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-mckinley-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-mckinley-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-sparc32', release: '3.1', reference: '2.4.27-9sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-sparc32 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-sparc32_2.4.27-9sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-sparc32-smp', release: '3.1', reference: '2.4.27-9sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-sparc32-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-sparc32-smp_2.4.27-9sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-sparc64', release: '3.1', reference: '2.4.27-9sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-sparc64 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-sparc64_2.4.27-9sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-4-sparc64-smp', release: '3.1', reference: '2.4.27-9sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-4-sparc64-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-4-sparc64-smp_2.4.27-9sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-apus', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-apus is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-apus_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-nubus', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-nubus is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-nubus_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-powerpc', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-powerpc is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-powerpc_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-headers-2.4.27-speakup', release: '3.1', reference: '2.4.27-1.1sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.4.27-speakup is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.4.27-speakup_2.4.27-1.1sarge5\n');
}
if (deb_check(prefix: 'kernel-image-2.4-386', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-386 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-386_101sarge2\n');
}
if (deb_check(prefix: 'kernel-image-2.4-586tsc', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-586tsc is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-586tsc_101sarge2\n');
}
if (deb_check(prefix: 'kernel-image-2.4-686', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-686 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-686_101sarge2\n');
}
if (deb_check(prefix: 'kernel-image-2.4-686-smp', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-686-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-686-smp_101sarge2\n');
}
if (deb_check(prefix: 'kernel-image-2.4-generic', release: '3.1', reference: '101sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-generic is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-generic_101sarge3\n');
}
if (deb_check(prefix: 'kernel-image-2.4-itanium', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-itanium is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-itanium_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4-itanium-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-itanium-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-itanium-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4-k6', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-k6 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-k6_101sarge2\n');
}
if (deb_check(prefix: 'kernel-image-2.4-k7', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-k7 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-k7_101sarge2\n');
}
if (deb_check(prefix: 'kernel-image-2.4-k7-smp', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-k7-smp_101sarge2\n');
}
if (deb_check(prefix: 'kernel-image-2.4-mckinley', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-mckinley is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-mckinley_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4-mckinley-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-mckinley-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-mckinley-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4-s390', release: '3.1', reference: '2.4.27-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-s390 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-s390_2.4.27-1sarge2\n');
}
if (deb_check(prefix: 'kernel-image-2.4-s390x', release: '3.1', reference: '2.4.27-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-s390x is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-s390x_2.4.27-1sarge2\n');
}
if (deb_check(prefix: 'kernel-image-2.4-smp', release: '3.1', reference: '101sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-smp_101sarge3\n');
}
if (deb_check(prefix: 'kernel-image-2.4-sparc32', release: '3.1', reference: '42sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-sparc32 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-sparc32_42sarge3\n');
}
if (deb_check(prefix: 'kernel-image-2.4-sparc32-smp', release: '3.1', reference: '42sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-sparc32-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-sparc32-smp_42sarge3\n');
}
if (deb_check(prefix: 'kernel-image-2.4-sparc64', release: '3.1', reference: '42sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-sparc64 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-sparc64_42sarge3\n');
}
if (deb_check(prefix: 'kernel-image-2.4-sparc64-smp', release: '3.1', reference: '42sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4-sparc64-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4-sparc64-smp_42sarge3\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-386', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-386 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-386_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-586tsc', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-586tsc is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-586tsc_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-686', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-686 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-686_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-686-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-686-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-686-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-generic', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-generic is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-generic_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-itanium', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-itanium is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-itanium_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-itanium-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-itanium-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-itanium-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-k6', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-k6 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-k6_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-k7', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-k7 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-k7_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-k7-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-k7-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-mckinley', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-mckinley is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-mckinley_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-mckinley-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-mckinley-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-mckinley-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-s390', release: '3.1', reference: '2.4.27-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-s390 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-s390_2.4.27-2sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-s390-tape', release: '3.1', reference: '2.4.27-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-s390-tape is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-s390-tape_2.4.27-2sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-s390x', release: '3.1', reference: '2.4.27-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-s390x is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-s390x_2.4.27-2sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-sparc32', release: '3.1', reference: '2.4.27-9sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-sparc32 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-sparc32_2.4.27-9sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-sparc32-smp', release: '3.1', reference: '2.4.27-9sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-sparc32-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-sparc32-smp_2.4.27-9sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-sparc64', release: '3.1', reference: '2.4.27-9sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-sparc64 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-sparc64_2.4.27-9sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-4-sparc64-smp', release: '3.1', reference: '2.4.27-9sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-4-sparc64-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-4-sparc64-smp_2.4.27-9sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-amiga', release: '3.1', reference: '2.4.27-3sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-amiga is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-amiga_2.4.27-3sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-apus', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-apus is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-apus_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-atari', release: '3.1', reference: '2.4.27-3sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-atari is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-atari_2.4.27-3sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-bast', release: '3.1', reference: '2.4.27-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-bast is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-bast_2.4.27-2sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-bvme6000', release: '3.1', reference: '2.4.27-3sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-bvme6000 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-bvme6000_2.4.27-3sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-lart', release: '3.1', reference: '2.4.27-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-lart is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-lart_2.4.27-2sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-mac', release: '3.1', reference: '2.4.27-3sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-mac is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-mac_2.4.27-3sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-mvme147', release: '3.1', reference: '2.4.27-3sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-mvme147 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-mvme147_2.4.27-3sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-mvme16x', release: '3.1', reference: '2.4.27-3sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-mvme16x is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-mvme16x_2.4.27-3sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-netwinder', release: '3.1', reference: '2.4.27-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-netwinder is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-netwinder_2.4.27-2sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-nubus', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-nubus is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-nubus_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-powerpc', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-powerpc is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-powerpc_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-powerpc-small', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-powerpc-small is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-powerpc-small_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-powerpc-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-powerpc-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-powerpc-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-q40', release: '3.1', reference: '2.4.27-3sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-q40 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-q40_2.4.27-3sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-r3k-kn02', release: '3.1', reference: '2.4.27-10.sarge4.040815-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-r3k-kn02 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-r3k-kn02_2.4.27-10.sarge4.040815-3\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-r4k-ip22', release: '3.1', reference: '2.4.27-10.sarge4.040815-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-r4k-ip22 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-r4k-ip22_2.4.27-10.sarge4.040815-3\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-r4k-kn04', release: '3.1', reference: '2.4.27-10.sarge4.040815-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-r4k-kn04 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-r4k-kn04_2.4.27-10.sarge4.040815-3\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-r5k-cobalt', release: '3.1', reference: '2.4.27-10.sarge4.040815-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-r5k-cobalt is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-r5k-cobalt_2.4.27-10.sarge4.040815-3\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-r5k-ip22', release: '3.1', reference: '2.4.27-10.sarge4.040815-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-r5k-ip22 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-r5k-ip22_2.4.27-10.sarge4.040815-3\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-r5k-lasat', release: '3.1', reference: '2.4.27-10.sarge4.040815-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-r5k-lasat is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-r5k-lasat_2.4.27-10.sarge4.040815-3\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-riscpc', release: '3.1', reference: '2.4.27-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-riscpc is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-riscpc_2.4.27-2sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-riscstation', release: '3.1', reference: '2.4.27-2sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-riscstation is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-riscstation_2.4.27-2sarge6\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-sb1-swarm-bn', release: '3.1', reference: '2.4.27-10.sarge4.040815-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-sb1-swarm-bn is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-sb1-swarm-bn_2.4.27-10.sarge4.040815-3\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-speakup', release: '3.1', reference: '2.4.27-1.1sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-speakup is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-speakup_2.4.27-1.1sarge5\n');
}
if (deb_check(prefix: 'kernel-image-2.4.27-xxs1500', release: '3.1', reference: '2.4.27-10.sarge4.040815-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.4.27-xxs1500 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.4.27-xxs1500_2.4.27-10.sarge4.040815-3\n');
}
if (deb_check(prefix: 'kernel-patch-2.4-i2c', release: '3.1', reference: '2.9.1-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-patch-2.4-i2c is vulnerable in Debian 3.1.\nUpgrade to kernel-patch-2.4-i2c_2.9.1-1sarge2\n');
}
if (deb_check(prefix: 'kernel-patch-2.4-lm-sensors', release: '3.1', reference: '2.9.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-patch-2.4-lm-sensors is vulnerable in Debian 3.1.\nUpgrade to kernel-patch-2.4-lm-sensors_2.9.1-1sarge4\n');
}
if (deb_check(prefix: 'kernel-patch-2.4.27-apus', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-patch-2.4.27-apus is vulnerable in Debian 3.1.\nUpgrade to kernel-patch-2.4.27-apus_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-patch-2.4.27-nubus', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-patch-2.4.27-nubus is vulnerable in Debian 3.1.\nUpgrade to kernel-patch-2.4.27-nubus_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-patch-2.4.27-powerpc', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-patch-2.4.27-powerpc is vulnerable in Debian 3.1.\nUpgrade to kernel-patch-2.4.27-powerpc_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-patch-debian-2.4.27', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-patch-debian-2.4.27 is vulnerable in Debian 3.1.\nUpgrade to kernel-patch-debian-2.4.27_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-pcmcia-modules-2.4-386', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-pcmcia-modules-2.4-386 is vulnerable in Debian 3.1.\nUpgrade to kernel-pcmcia-modules-2.4-386_101sarge2\n');
}
if (deb_check(prefix: 'kernel-pcmcia-modules-2.4-586tsc', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-pcmcia-modules-2.4-586tsc is vulnerable in Debian 3.1.\nUpgrade to kernel-pcmcia-modules-2.4-586tsc_101sarge2\n');
}
if (deb_check(prefix: 'kernel-pcmcia-modules-2.4-686', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-pcmcia-modules-2.4-686 is vulnerable in Debian 3.1.\nUpgrade to kernel-pcmcia-modules-2.4-686_101sarge2\n');
}
if (deb_check(prefix: 'kernel-pcmcia-modules-2.4-686-smp', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-pcmcia-modules-2.4-686-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-pcmcia-modules-2.4-686-smp_101sarge2\n');
}
if (deb_check(prefix: 'kernel-pcmcia-modules-2.4-k6', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-pcmcia-modules-2.4-k6 is vulnerable in Debian 3.1.\nUpgrade to kernel-pcmcia-modules-2.4-k6_101sarge2\n');
}
if (deb_check(prefix: 'kernel-pcmcia-modules-2.4-k7', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-pcmcia-modules-2.4-k7 is vulnerable in Debian 3.1.\nUpgrade to kernel-pcmcia-modules-2.4-k7_101sarge2\n');
}
if (deb_check(prefix: 'kernel-pcmcia-modules-2.4-k7-smp', release: '3.1', reference: '101sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-pcmcia-modules-2.4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-pcmcia-modules-2.4-k7-smp_101sarge2\n');
}
if (deb_check(prefix: 'kernel-pcmcia-modules-2.4.27-4-386', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-pcmcia-modules-2.4.27-4-386 is vulnerable in Debian 3.1.\nUpgrade to kernel-pcmcia-modules-2.4.27-4-386_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-pcmcia-modules-2.4.27-4-586tsc', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-pcmcia-modules-2.4.27-4-586tsc is vulnerable in Debian 3.1.\nUpgrade to kernel-pcmcia-modules-2.4.27-4-586tsc_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-pcmcia-modules-2.4.27-4-686', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-pcmcia-modules-2.4.27-4-686 is vulnerable in Debian 3.1.\nUpgrade to kernel-pcmcia-modules-2.4.27-4-686_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-pcmcia-modules-2.4.27-4-686-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-pcmcia-modules-2.4.27-4-686-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-pcmcia-modules-2.4.27-4-686-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-pcmcia-modules-2.4.27-4-k6', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-pcmcia-modules-2.4.27-4-k6 is vulnerable in Debian 3.1.\nUpgrade to kernel-pcmcia-modules-2.4.27-4-k6_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-pcmcia-modules-2.4.27-4-k7', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-pcmcia-modules-2.4.27-4-k7 is vulnerable in Debian 3.1.\nUpgrade to kernel-pcmcia-modules-2.4.27-4-k7_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-pcmcia-modules-2.4.27-4-k7-smp', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-pcmcia-modules-2.4.27-4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-pcmcia-modules-2.4.27-4-k7-smp_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-source-2.4.27', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-source-2.4.27 is vulnerable in Debian 3.1.\nUpgrade to kernel-source-2.4.27_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'kernel-tree-2.4.27', release: '3.1', reference: '2.4.27-10sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-tree-2.4.27 is vulnerable in Debian 3.1.\nUpgrade to kernel-tree-2.4.27_2.4.27-10sarge6\n');
}
if (deb_check(prefix: 'libsensors-dev', release: '3.1', reference: '2.9.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsensors-dev is vulnerable in Debian 3.1.\nUpgrade to libsensors-dev_2.9.1-1sarge4\n');
}
if (deb_check(prefix: 'libsensors3', release: '3.1', reference: '2.9.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsensors3 is vulnerable in Debian 3.1.\nUpgrade to libsensors3_2.9.1-1sarge4\n');
}
if (deb_check(prefix: 'lm-sensors', release: '3.1', reference: '2.9.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lm-sensors is vulnerable in Debian 3.1.\nUpgrade to lm-sensors_2.9.1-1sarge4\n');
}
if (deb_check(prefix: 'lm-sensors-2.4.27-4-386', release: '3.1', reference: '2.9.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lm-sensors-2.4.27-4-386 is vulnerable in Debian 3.1.\nUpgrade to lm-sensors-2.4.27-4-386_2.9.1-1sarge4\n');
}
if (deb_check(prefix: 'lm-sensors-2.4.27-4-586tsc', release: '3.1', reference: '2.9.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lm-sensors-2.4.27-4-586tsc is vulnerable in Debian 3.1.\nUpgrade to lm-sensors-2.4.27-4-586tsc_2.9.1-1sarge4\n');
}
if (deb_check(prefix: 'lm-sensors-2.4.27-4-686', release: '3.1', reference: '2.9.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lm-sensors-2.4.27-4-686 is vulnerable in Debian 3.1.\nUpgrade to lm-sensors-2.4.27-4-686_2.9.1-1sarge4\n');
}
if (deb_check(prefix: 'lm-sensors-2.4.27-4-686-smp', release: '3.1', reference: '2.9.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lm-sensors-2.4.27-4-686-smp is vulnerable in Debian 3.1.\nUpgrade to lm-sensors-2.4.27-4-686-smp_2.9.1-1sarge4\n');
}
if (deb_check(prefix: 'lm-sensors-2.4.27-4-k6', release: '3.1', reference: '2.9.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lm-sensors-2.4.27-4-k6 is vulnerable in Debian 3.1.\nUpgrade to lm-sensors-2.4.27-4-k6_2.9.1-1sarge4\n');
}
if (deb_check(prefix: 'lm-sensors-2.4.27-4-k7', release: '3.1', reference: '2.9.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lm-sensors-2.4.27-4-k7 is vulnerable in Debian 3.1.\nUpgrade to lm-sensors-2.4.27-4-k7_2.9.1-1sarge4\n');
}
if (deb_check(prefix: 'lm-sensors-2.4.27-4-k7-smp', release: '3.1', reference: '2.9.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lm-sensors-2.4.27-4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to lm-sensors-2.4.27-4-k7-smp_2.9.1-1sarge4\n');
}
if (deb_check(prefix: 'lm-sensors-source', release: '3.1', reference: '2.9.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lm-sensors-source is vulnerable in Debian 3.1.\nUpgrade to lm-sensors-source_2.9.1-1sarge4\n');
}
if (deb_check(prefix: 'mindi-kernel', release: '3.1', reference: '2.4.27-2sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mindi-kernel is vulnerable in Debian 3.1.\nUpgrade to mindi-kernel_2.4.27-2sarge5\n');
}
if (deb_check(prefix: 'mips-tools', release: '3.1', reference: '2.4.27-10.sarge4.040815-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mips-tools is vulnerable in Debian 3.1.\nUpgrade to mips-tools_2.4.27-10.sarge4.040815-3\n');
}
if (deb_check(prefix: 'pcmcia-modules-2.4.27-4-386', release: '3.1', reference: '3.2.5+2sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pcmcia-modules-2.4.27-4-386 is vulnerable in Debian 3.1.\nUpgrade to pcmcia-modules-2.4.27-4-386_3.2.5+2sarge2\n');
}
if (deb_check(prefix: 'pcmcia-modules-2.4.27-4-586tsc', release: '3.1', reference: '3.2.5+2sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pcmcia-modules-2.4.27-4-586tsc is vulnerable in Debian 3.1.\nUpgrade to pcmcia-modules-2.4.27-4-586tsc_3.2.5+2sarge2\n');
}
if (deb_check(prefix: 'pcmcia-modules-2.4.27-4-686', release: '3.1', reference: '3.2.5+2sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pcmcia-modules-2.4.27-4-686 is vulnerable in Debian 3.1.\nUpgrade to pcmcia-modules-2.4.27-4-686_3.2.5+2sarge2\n');
}
if (deb_check(prefix: 'pcmcia-modules-2.4.27-4-686-smp', release: '3.1', reference: '3.2.5+2sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pcmcia-modules-2.4.27-4-686-smp is vulnerable in Debian 3.1.\nUpgrade to pcmcia-modules-2.4.27-4-686-smp_3.2.5+2sarge2\n');
}
if (deb_check(prefix: 'pcmcia-modules-2.4.27-4-k6', release: '3.1', reference: '3.2.5+2sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pcmcia-modules-2.4.27-4-k6 is vulnerable in Debian 3.1.\nUpgrade to pcmcia-modules-2.4.27-4-k6_3.2.5+2sarge2\n');
}
if (deb_check(prefix: 'pcmcia-modules-2.4.27-4-k7', release: '3.1', reference: '3.2.5+2sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pcmcia-modules-2.4.27-4-k7 is vulnerable in Debian 3.1.\nUpgrade to pcmcia-modules-2.4.27-4-k7_3.2.5+2sarge2\n');
}
if (deb_check(prefix: 'pcmcia-modules-2.4.27-4-k7-smp', release: '3.1', reference: '3.2.5+2sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pcmcia-modules-2.4.27-4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to pcmcia-modules-2.4.27-4-k7-smp_3.2.5+2sarge2\n');
}
if (deb_check(prefix: 'sensord', release: '3.1', reference: '2.9.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package sensord is vulnerable in Debian 3.1.\nUpgrade to sensord_2.9.1-1sarge4\n');
}
if (deb_check(prefix: 'systemimager-boot-i386-standard', release: '3.1', reference: '3.2.3-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package systemimager-boot-i386-standard is vulnerable in Debian 3.1.\nUpgrade to systemimager-boot-i386-standard_3.2.3-6sarge5\n');
}
if (deb_check(prefix: 'systemimager-boot-ia64-standard', release: '3.1', reference: '3.2.3-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package systemimager-boot-ia64-standard is vulnerable in Debian 3.1.\nUpgrade to systemimager-boot-ia64-standard_3.2.3-6sarge5\n');
}
if (deb_check(prefix: 'systemimager-client', release: '3.1', reference: '3.2.3-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package systemimager-client is vulnerable in Debian 3.1.\nUpgrade to systemimager-client_3.2.3-6sarge5\n');
}
if (deb_check(prefix: 'systemimager-common', release: '3.1', reference: '3.2.3-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package systemimager-common is vulnerable in Debian 3.1.\nUpgrade to systemimager-common_3.2.3-6sarge5\n');
}
if (deb_check(prefix: 'systemimager-doc', release: '3.1', reference: '3.2.3-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package systemimager-doc is vulnerable in Debian 3.1.\nUpgrade to systemimager-doc_3.2.3-6sarge5\n');
}
if (deb_check(prefix: 'systemimager-server', release: '3.1', reference: '3.2.3-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package systemimager-server is vulnerable in Debian 3.1.\nUpgrade to systemimager-server_3.2.3-6sarge5\n');
}
if (deb_check(prefix: 'systemimager-server-flamethrowerd', release: '3.1', reference: '3.2.3-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package systemimager-server-flamethrowerd is vulnerable in Debian 3.1.\nUpgrade to systemimager-server-flamethrowerd_3.2.3-6sarge5\n');
}
if (w) { security_hole(port: 0, data: desc); }
