# This script was automatically generated from the dsa-1507
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Peter Paul Elfferich discovered that turba2, a contact management component
for horde framework did not correctly check access rights before allowing
users to edit addresses.  This could result in valid users being able to
alter private address records.
For the stable distribution (etch), this problem has been fixed in version
2.1.3-1etch1.
For the old stable distribution (sarge), this problem has been fixed in
version 2.0.2-1sarge1.
For the unstable distribution (sid), this problem has been fixed in version
2.1.7-1.
We recommend that you upgrade your turba2 package.


Solution : http://www.debian.org/security/2008/dsa-1507
Risk factor : High';

if (description) {
 script_id(31151);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1507");
 script_cve_id("CVE-2008-0807");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1507] DSA-1507-1 turba2");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1507-1 turba2");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'turba2', release: '3.1', reference: '2.0.2-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package turba2 is vulnerable in Debian 3.1.\nUpgrade to turba2_2.0.2-1sarge1\n');
}
if (deb_check(prefix: 'turba2', release: '4.0', reference: '2.1.3-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package turba2 is vulnerable in Debian 4.0.\nUpgrade to turba2_2.1.3-1etch1\n');
}
if (deb_check(prefix: 'turba2', release: '4.0', reference: '2.1.3-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package turba2 is vulnerable in Debian etch.\nUpgrade to turba2_2.1.3-1etch1\n');
}
if (deb_check(prefix: 'turba2', release: '3.1', reference: '2.0.2-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package turba2 is vulnerable in Debian sarge.\nUpgrade to turba2_2.0.2-1sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
