# This script was automatically generated from the dsa-1510
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Chris Evans discovered a buffer overflow in the color space handling
code of the Ghostscript PostScript/PDF interpreter, which might result
in the execution of arbitrary code if a user is tricked into processing
a malformed file.
For the stable distribution (etch), this problem has been fixed in version
8.54.dfsg.1-5etch1 of gs-gpl and 8.15.3.dfsg.1-1etch1 of gs-esp.
For the old stable distribution (sarge), this problem has been fixed in
version 8.01-6 of gs-gpl and 7.07.1-9sarge1 of gs-esp.
The unstable distribution (sid) will be fixed soon.
We recommend that you upgrade your gs-esp and gs-gpl packages.


Solution : http://www.debian.org/security/2008/dsa-1510
Risk factor : High';

if (description) {
 script_id(31303);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1510");
 script_cve_id("CVE-2008-0411");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1510] DSA-1510-1 ghostscript");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1510-1 ghostscript");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'gs', release: '3.1', reference: '8.01-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gs is vulnerable in Debian 3.1.\nUpgrade to gs_8.01-6\n');
}
if (deb_check(prefix: 'gs-esp', release: '3.1', reference: '7.07.1-9sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gs-esp is vulnerable in Debian 3.1.\nUpgrade to gs-esp_7.07.1-9sarge1\n');
}
if (deb_check(prefix: 'gs-gpl', release: '3.1', reference: '8.01-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gs-gpl is vulnerable in Debian 3.1.\nUpgrade to gs-gpl_8.01-6\n');
}
if (deb_check(prefix: 'gs', release: '4.0', reference: '8.54.dfsg.1-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gs is vulnerable in Debian 4.0.\nUpgrade to gs_8.54.dfsg.1-5etch1\n');
}
if (deb_check(prefix: 'gs-esp', release: '4.0', reference: '8.15.3.dfsg.1-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gs-esp is vulnerable in Debian 4.0.\nUpgrade to gs-esp_8.15.3.dfsg.1-1etch1\n');
}
if (deb_check(prefix: 'gs-gpl', release: '4.0', reference: '8.54.dfsg.1-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gs-gpl is vulnerable in Debian 4.0.\nUpgrade to gs-gpl_8.54.dfsg.1-5etch1\n');
}
if (deb_check(prefix: 'gs-esp', release: '4.0', reference: '8.54.dfsg')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gs-esp is vulnerable in Debian etch.\nUpgrade to gs-esp_8.54.dfsg\n');
}
if (deb_check(prefix: 'gs-esp', release: '3.1', reference: '8')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gs-esp is vulnerable in Debian sarge.\nUpgrade to gs-esp_8\n');
}
if (w) { security_hole(port: 0, data: desc); }
