# This script was automatically generated from the dsa-1511
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several local vulnerabilities have been discovered in libicu,
International Components for Unicode, The Common Vulnerabilities and
Exposures project identifies the following problems:
 
  libicu in International Components for Unicode (ICU) 3.8.1 and earlier
  attempts to process backreferences to the nonexistent capture group
  zero (aka \\0), which might allow context-dependent attackers to read
  from, or write to, out-of-bounds memory locations, related to
  corruption of REStackFrames.
 
  Heap-based buffer overflow in the doInterval function in regexcmp.cpp
  in libicu in International Components for Unicode (ICU) 3.8.1 and
  earlier allows context-dependent attackers to cause a denial of
  service (memory consumption) and possibly have unspecified other
  impact via a regular expression that writes a large amount of data to
  the backtracking stack.
For the stable distribution (etch), these problems have been fixed in
version 3.6-2etch1.
For the unstable distribution (sid), these problems have been fixed in
version 3.8-6.
We recommend that you upgrade your libicu package.


Solution : http://www.debian.org/security/2008/dsa-1511
Risk factor : High';

if (description) {
 script_id(31358);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1511");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1511] DSA-1511-1 libicu");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1511-1 libicu");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'icu-doc', release: '4.0', reference: '3.6-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package icu-doc is vulnerable in Debian 4.0.\nUpgrade to icu-doc_3.6-2etch1\n');
}
if (deb_check(prefix: 'libicu36', release: '4.0', reference: '3.6-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libicu36 is vulnerable in Debian 4.0.\nUpgrade to libicu36_3.6-2etch1\n');
}
if (deb_check(prefix: 'libicu36-dev', release: '4.0', reference: '3.6-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libicu36-dev is vulnerable in Debian 4.0.\nUpgrade to libicu36-dev_3.6-2etch1\n');
}
if (deb_check(prefix: 'libicu', release: '4.0', reference: '3.6-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libicu is vulnerable in Debian etch.\nUpgrade to libicu_3.6-2etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
