# This script was automatically generated from the dsa-1512
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Ulf H&auml;rnhammar discovered that Evolution, the e-mail and groupware suite,
had a format string vulnerability in the parsing of encrypted mail messages.
If the user opened a specially crafted email message, code execution was
possible.
For the stable distribution (etch), this problem has been fixed in version
2.6.3-6etch2.
For the old stable distribution (sarge), this problem has been fixed in
version 2.0.4-2sarge3. Some architectures have not yet completed building
the updated package for sarge, they will be added as they come available.
For the unstable distribution (sid), this problem has been fixed in
version 2.12.3-1.1.
We recommend that you upgrade your evolution package.


Solution : http://www.debian.org/security/2008/dsa-1512
Risk factor : High';

if (description) {
 script_id(31359);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1512");
 script_cve_id("CVE-2008-0072");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1512] DSA-1512-1 evolution");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1512-1 evolution");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'evolution', release: '3.1', reference: '2.0.4-2sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution is vulnerable in Debian 3.1.\nUpgrade to evolution_2.0.4-2sarge3\n');
}
if (deb_check(prefix: 'evolution-dev', release: '3.1', reference: '2.0.4-2sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-dev is vulnerable in Debian 3.1.\nUpgrade to evolution-dev_2.0.4-2sarge3\n');
}
if (deb_check(prefix: 'evolution', release: '4.0', reference: '2.6.3-6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution is vulnerable in Debian 4.0.\nUpgrade to evolution_2.6.3-6etch2\n');
}
if (deb_check(prefix: 'evolution-common', release: '4.0', reference: '2.6.3-6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-common is vulnerable in Debian 4.0.\nUpgrade to evolution-common_2.6.3-6etch2\n');
}
if (deb_check(prefix: 'evolution-dbg', release: '4.0', reference: '2.6.3-6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-dbg is vulnerable in Debian 4.0.\nUpgrade to evolution-dbg_2.6.3-6etch2\n');
}
if (deb_check(prefix: 'evolution-dev', release: '4.0', reference: '2.6.3-6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-dev is vulnerable in Debian 4.0.\nUpgrade to evolution-dev_2.6.3-6etch2\n');
}
if (deb_check(prefix: 'evolution-plugins', release: '4.0', reference: '2.6.3-6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-plugins is vulnerable in Debian 4.0.\nUpgrade to evolution-plugins_2.6.3-6etch2\n');
}
if (deb_check(prefix: 'evolution-plugins-experimental', release: '4.0', reference: '2.6.3-6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution-plugins-experimental is vulnerable in Debian 4.0.\nUpgrade to evolution-plugins-experimental_2.6.3-6etch2\n');
}
if (deb_check(prefix: 'evolution', release: '4.0', reference: '2.6.3-6etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution is vulnerable in Debian etch.\nUpgrade to evolution_2.6.3-6etch2\n');
}
if (deb_check(prefix: 'evolution', release: '3.1', reference: '2.0.4-2sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package evolution is vulnerable in Debian sarge.\nUpgrade to evolution_2.0.4-2sarge3\n');
}
if (w) { security_hole(port: 0, data: desc); }
