#
# (C) Tenable Network Security
#


  desc["english"] = "
Synopsis :

The remote proxy server is affected by multiple denial-of-service vulnerabilities.

Description :

According to its banner, the remote host is running a version of the 
DeleGate proxy server before 9.7.5. Such versions contain several issues
that could result in service disruptions when processing user input or 
handling malicious traffic.

See also :

http://www.delegate.org/mail-lists/delegate-en/3829
http://www.delegate.org/mail-lists/delegate-en/3856
http://www.delegate.org/mail-lists/delegate-en/3875

Solution :

Upgrade to DeleGate 9.7.5 or later.

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:P)";


if (description) {
  script_id(27582);
  script_version("$Revision: 1.1 $");

  script_bugtraq_id(26174);
	
  name["english"] = "DeleGate Proxy Server < 9.7.5";
  script_name(english:name["english"]);
 
  script_description(english:desc["english"]);
 
  summary["english"] = "Checks version of DeleGate Proxy server";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Denial of Service");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
  script_dependencies("proxy_use.nasl");	
  script_require_ports("Services/http_proxy", 8080,8081);

  exit(0);
}

include("global_settings.inc");
include("http_func.inc");

if (report_paranoia < 2) exit(0);

port = get_kb_item("Services/http_proxy");
if (!port) port = 8080;
if (!get_port_state(port)) exit(0);

banner = get_http_banner(port:port);

if (banner && "DeleGate-Ver: " >< banner)
{
  headers = banner - strstr(banner, '\n\n');
  ver = strstr(headers, "DeleGate-Ver: ") - "DeleGate-Ver: ";
  if (ver) ver = ver - strstr(ver, '\n');
  if (ver && " (delay=" >< ver ) ver = ver - strstr(ver, " (delay=");

  # Versions < 9.7.5 are vulnerable
  if (ver =~ "^([0-8]\..*)|(9\.(([0-6]\..*)|7\.[0-4][^0-9]))") 
  {
      extra = 'According to its banner, the remote proxy is DeleGate version '+ ver + '.\n';
      security_warning(port:port,extra:extra);
  }
}
