#
# This script was rewritten by Tenable Network Security
#

 desc["english"] = "
Synopsis :

A management server is running on the remote host.

Description :

The remote host is running the Dell OpenManage Web Server.

See also : 

http://www.nessus.org/u?123f3863

Risk factor : 

None";


if(description)
{
 script_id(12295);
 script_version("$Revision: 1.11 $");
 
 name["english"] = "Dell OpenManage Web Server Detection";
 script_name(english:name["english"]);

 script_description(english:desc["english"]);

 summary["english"] = "Dell OpenManage Web Server Detection";

 script_category(ACT_GATHER_INFO);
 script_summary(english:summary["english"]);
 script_family(english:"Service detection");

 script_copyright(english:"This is script is Copyright (C) 2007 Tenable Network Security, Inc");
 script_require_ports(1311);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");

port = 1311;

if ( ! get_port_state(port) ) exit(0);

soc = open_sock_tcp(port, transport:ENCAPS_SSLv23);
if ( ! soc ) exit(0);

url = "/servlet/UDataArea?plugin=com.dell.oma.webplugins.AboutWebPlugin";
request = http_get(port:port, item:url);

send(socket:soc, data:request);
buffer = http_recv(socket:soc);
	
close(soc);

if ( egrep(pattern:".*<br>Version [0-9]+\.[0-9]+\.[0-9]+<br>Copyright \(C\) Dell Inc.*", string:buffer) )
{
 version = ereg_replace(pattern:".*<br>Version ([0-9]+\.[0-9]+\.[0-9]+)<br>.*", string:buffer, replace:"\1");

 report = string (desc["english"],
		"\n\nPlugin output :\n\n",
		"The Dell OpenManage Server version is ", version, "\n\n");

 security_note (port:port, data:report);
 register_service(port:port, ipproto:"tcp", proto:"dom");
}
