#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25292);
  script_version("$Revision: 1.3 $");

  script_name(english:"Centennial IP Transfer Agent Detection");
  script_summary(english:"Tries to perform initial handshake with XFERWAN");

  desc = "
Synopsis :

A network auditing service is listening on the remote host. 

Description :

The remote service appears to be an IP Transfer Agent used by
Centennial Discovery, or one of its OEM versions.  Discovery is an
enterprise tool for network auditing and monitoring, and the IP
Transfer Agent (XFERWAN) offers a way for client agents and the
application's Control Center to communicate. 

See also :

http://www.centennial-software.com/products/discovery/

Solution :

Limit incoming traffic to this port if desired. 

Risk factor :

None";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Service detection");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("find_service1.nasl");
  script_require_ports("Services/unknown", 5003);

  exit(0);
}


include("byte_func.inc");
include("global_settings.inc");
include("misc_func.inc");


if (thorough_tests && ! get_kb_item("global_settings/disable_service_discovery") )
{
  port = get_unknown_svc(5003);
  if (!port) exit(0);
}
else port = 5003;
if (known_service(port:port)) exit(0);
if (!get_tcp_port_state(port)) exit(0);


soc = open_sock_tcp(port);
if (!soc) exit(0);


# Try to initiate a connection.
client = "039156CC-F90DF4DA-1702E29D-7BCC88FB";
magic = 0xedede441;

set_byte_order(BYTE_ORDER_LITTLE_ENDIAN);
req = 
  crap(data:raw_string(0x00), length:128) +
  client +
  crap(data:raw_string(0x00), length:9);
req = 
  mkdword(magic) +
  mkdword(1) +
  mkdword(16+strlen(req)) +
  mkdword(-1) +
  req;
send(socket:soc, data:req);
res = recv(socket:soc, length:256);
close(soc);


# If the response looks ok...
if (
  strlen(res) == 188 && 
  getdword(blob:res, pos:0) == magic &&
  getdword(blob:res, pos:4) == 5 &&
  substr(res, 0x90, 0xb2) == client
)
{
  # Register and report the service.
  register_service(port:port, ipproto:"tcp", proto:"xferwan");
  security_note(port);
}
