#
# (C) Tenable Network Security, Inc.
#


 desc["english"] = "
Synopsis :

The remote ASP.NET web server does have custom errors set

Description :

The remote ASP.NET web server is configured to show verbose
error messages, which might lead into the disclosure of potential
sensitive information about the remote installation (such as the
path under which the remote web server resides) or about the
remote ASP.NET applications.

Solution :

Configure your server such as the option 'customErrors mode' is set
to 'On' instead of 'Off'

Risk factor :

Low / CVSS Base Score : 0.8
(AV:L/AC:H/Au:R/C:P/I:N/A:N/B:N)";


if(description)
{
 script_id(24244);
 script_version ("$Revision: 1.4 $");
 name["english"] = "Microsoft .NET Custom Errors Not Set";
 script_name(english:name["english"]);

 script_description(english:desc["english"]);

 summary["english"] = "Checks for the error message of the .NET framework";

 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);


 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 family["english"] = "Web Servers";
 script_family(english:family["english"]);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#
include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");


list = make_list(".ashx", ".aspx", ".asmx");
port = get_http_port(default:80);


foreach ext (list) 
{
req = http_get(item:"/" + rand_str(length:8) + ext,
	       port:port);

res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
 if ( "[FileNotFoundException]:" >< res || "[HttpException]:" >< res )
	{
	 start = strstr(res, "[FileNotFoundException]");
 	 if ( ! start ) start = strstr(res, "[HttpException]");
	 end   = strstr(start, "-->");
 	 msg = str_replace(find:"&quot;", replace:"'", string:start - end);
	 security_note(port:port,
		data:desc["english"] + '\n\nPlugin output :\n\nThe following error message could be obtained :\n\n' + msg);
	 exit(0);
	}
}

