#
# (C) Tenable Network Security, Inc.
#


 desc["english"] = "
Synopsis :

It is possible to enumerate the remote .NET handlers used by the
remote web server. 

Description :

It is possible to obtain the list of handlers the remote ASP.NET web
server supports. 

See also : 

http://support.microsoft.com/kb/815145

Solution :

None

Risk factor :

None";


if(description)
{
 script_id(24242);
 script_version ("$Revision: 1.5 $");
 name["english"] = "Microsoft .NET Handlers Enumeration";
 script_name(english:name["english"]);

 script_description(english:desc["english"]);

 summary["english"] = "Checks for the version of the .NET framework";

 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);


 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 family["english"] = "Web Servers";
 script_family(english:family["english"]);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#
include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");


list = make_list(".ashx", ".aspx", ".asmx", ".rem", ".soap");
port = get_http_port(default:80);


foreach ext (list) 
{
req = http_get(item:"/" + rand_str(length:8) + ext,
	       port:port);

res = http_keepalive_send_recv(port:port, data:req);
 if ( "[FileNotFoundException]:" >< res ||
      "[HttpException]:" >< res ||
      "System.Runtime.Remoting.RemotingException:" >< res ||
      egrep(pattern:"^Location:.*aspxerrorpath=", string:res) )
	{
	 	rep += ' - ' + ext + '\n';
		set_kb_item(name:"www/" + port + "/.NetExtensions", value:ext);
	}
}


if ( rep )
{
 security_note(port:port,
		data:desc["english"] + '\n\nPlugin output :\n\nThe remote extensions are handled by the remote ASP.NET server :\n' + rep);

	
}
