#
# (C) Tenable Network Security, Inc.
#


 desc["english"] = "
Synopsis :

It is possible to obtain the version number of the more Microsoft .NET
Framework. 

Description :

By requesting a non-existing .aspx file on the remote web server, it
is possible to obtain the exact version number of the remote .NET
framework. 

Solution :

Configure IIS to return custom error messages instead of the default
.NET error messages by setting the option 'customErrors mode' to 'On'
or 'RemoteOnly'. 

Risk factor :

None";


if(description)
{
 script_id(24243);
 script_version ("$Revision: 1.3 $");
 name["english"] = "Microsoft .NET Version Information Disclosure";
 script_name(english:name["english"]);

 script_description(english:desc["english"]);

 summary["english"] = "Checks for the version of the .NET framework";

 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);


 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 family["english"] = "Web Servers";
 script_family(english:family["english"]);
 script_dependencie("dotnet_framework_handlers.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#
include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");




port = get_http_port(default:80);
exts = get_kb_list("www/" + port + "/.NetExtensions");
ext  = ".aspx";
if ( ! isnull(exts) ) 
{
  exts = make_list(exts);
  foreach item ( exts )
	{
	  if ( item == ".mspx" || item == ".ashx") ext = item;
	}
}

req = http_get(item:"/" + rand_str(length:8) + ext, port:port);

res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
# Multi-lingual support
line = egrep(pattern:"Microsoft \.NET Framework.*:[0-9.]+.*ASP\.NET.*[0-9.]+", string:res);
if ( line )
{
 line = ereg_replace(pattern:".*<b>.*</b>&nbsp;", 	
		      replace:"",
		     string:line);
 framework_version = ereg_replace(pattern:".*:([0-9.]+).*ASP\.NET.*",
				  replace:"\1",
				  string:line);
 asp_version = ereg_replace(pattern:".*:[0-9.]+.*ASP\.NET.*:([0-9.]+).*",
				  replace:"\1",
				  string:line);

 set_kb_item(name:"www/" + port + "/Microsoft_.NET_Framework_Version", value:framework_version);
 set_kb_item(name:"www/" + port + "/ASP.NET_Version", value:asp_version);
 set_kb_item(name:"Services/www/ASP.Net", value:port);
 report = desc["english"] + '\n\nPlugin output :\n\n' + line;
 security_note(port:port, data:report);
}
