#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

A TCP channel is listening on the remote host. 

Description :

The remote host is running a TCP-based .NET Remoting Channel Service,
aka a 'TCP channel'.  .NET Remoting is an API developed by Microsoft
and used for interprocess communications, and a channel service
provides the mechanism by which such communications occur.  Two
channels services are supplied as part of Microsoft's .NET Framework -
a TCP channel, which uses binary payloads, and an HTTP channel, which
uses SOAP by default. 

See also :

http://msdn2.microsoft.com/en-us/library/72x4h507.aspx
http://en.wikipedia.org/wiki/.NET_Remoting

Solution :

Limit incoming traffic to this port if desired. 

Risk factor :

None";


if (description)
{
  script_id(24018);
  script_version("$Revision: 1.4 $");

  script_name(english:"TCP Channel Detection");
  script_summary(english:"Detects a TCP Channel for .NET Remoting Services");

  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Service detection");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

  script_dependencies("find_service1.nasl");
  script_require_ports("Services/remoting_tcp");

  exit(0);
}


include("byte_func.inc");
include("global_settings.inc");
include("misc_func.inc");


port = get_kb_item("Services/remoting_tcp");
if (!port) exit(0);
if (!get_tcp_port_state(port)) exit(0);


soc = open_sock_tcp(port);
if (!soc) exit(0);


set_byte_order(BYTE_ORDER_LITTLE_ENDIAN);


# Define a serialized object using the binary formatter.
namespace = "NessusPlugins";
class = "FooServer";
assembly = "object";
method = "BarMethod";
endpoint = "NASL";
arg = "Tenable";

typename = string(namespace, ".", class, ", ", assembly);
classname = string(
  typename, ", ",
  "Version=0.0.0.0, ",
  "Culture=neutral, ",
  "PublicKeyToken=null"
);
sobj = 
  raw_string(                          # header (constant?)
    0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
    0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00
  ) +
  mkbyte(21) +                         # method call
    mkbyte(18) +                       #   method call flags (18 => primative args & ExcludeLogicalCallContext)
    mkbyte(0) +                        #   constant?
    mkbyte(0) +                        #   constant?
    mkbyte(0) +                        #   constant?
                                       #   method name
      mkbyte(18) +                     #     primitive type code (18 => string)
        mkbyte(strlen(method)) +       #       length
        method +                       #       string chars
                                       #   class name (namespace and assembly)
      mkbyte(18) +                     #     primitive type code (18 => string)
        mkbyte(strlen(classname)) +    #       length
        classname +                    #       string chars
  mkdword(1) +                         # number of parameters (1)
    mkbyte(18) +                       #   primitive type code (18 => string)
      mkbyte(strlen(arg)) +            #     length
      arg +                            #     string chars
  mkbyte(0x0b);                        # end


# Send an activation request.
uri = string("tcp://", get_host_name(), ":", port, "/", endpoint);
type = "application/octet-stream";

req = 
  ".NET" +                             # magic
  mkword(1) + mkdword(0) +             # ?
  mkdword(strlen(sobj)) +              # length of serialized object
  mkword(4) +                          # ?
  mkbyte(1) +                          # ?
  mkbyte(1) +                          # ?
  mkdword(strlen(uri)) + uri +         # uri
  mkword(6) +                          # ?
  mkbyte(1) +                          # ?
  mkbyte(1) +                          # ?
  mkdword(strlen(type)) + type +       # mime type
  mkword(0);
send(socket:soc, data:req);
send(socket:soc, data:sobj);

res = recv(socket:soc, length:16);
if (res == NULL) exit(0);


# If ...
if (
  # the response is 16 bytes long and...
  strlen(res) == 16 && 
  # it starts with the magic header.
  (".NET" + mkword(1) + mkdword(2)) == substr(res, 0, 9)
)
{
  type = getword(blob:res, pos:14);

  # Read the response.
  if (type == 0)
  {
    len = getdword(blob:res, pos:10);
    res = recv(socket:soc, length:len);
  }
  else {
    res = recv(socket:soc, length:1024);
  }
  if (res == NULL) exit(0);

  # If ...
  if (
    (
      type == 0 &&
      # the response length is correct and...
      strlen(res) == len &&
      # it has a (partial) object header and...
      raw_string(0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00) == substr(res, 9,16) &&
      # it's an method response and...
      getbyte(blob:res, pos:17) == 22 &&
      # response ends with 0x0b
      getbyte(blob:res, pos:len-1) == 0x0b
    ) ||
    (
      type == 2 &&
      ".Runtime.Remoting." >< res
    )
  ) security_note(port);
}
