#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote service is affected by a buffer overflow vulnerability. 

Description :

According to its version number, the installation of eScan on the
remote host includes a service, the MicroWorld Agent service, for
remote administration that fails to properly handle overly-long
commands.  A remote attacker can leverage this issue to crash the
service or even execute arbitrary code. 

Since the service operates with LocalSystem privileges, successful
exploitation could lead to a complete compromise of the affected host. 

See also :

http://secunia.com/secunia_research/2007-54/advisory/

Solution :

Upgrade to eScan version 9.0.718.1 or later as that reportedly
resolves the issue.

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(25296);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-2687");
  script_bugtraq_id(24112);
  script_xref(name:"OSVDB", value:"36580");

  script_name(english:"eScan < 9.0.718.1 Buffer Overflow Vulnerability");
  script_summary(english:"Checks version number of eScan");

  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  if ( NASL_LEVEL >= 3000 )
  	script_dependencies("escan_detect.nbin");
  script_require_keys("eScan/Version");
  script_require_ports("Services/mwagent", 2222);

  exit(0);
}


if ( NASL_LEVEL < 3000 ) exit(0);
port = get_kb_item("Services/mwagent");
if (!port) port = 2222;
if (!get_port_state(port)) exit(0);


ver = get_kb_item("eScan/Version");
if (isnull(ver)) exit(0);

iver = split(ver, sep:'.', keep:FALSE);
for (i=0; i<max_index(iver); i++)
  iver[i] = int(iver[i]);


if (
  iver[0] < 9 ||
  (
    iver[0] == 9 && iver[1] == 0 &&
    (
      iver[2] < 718 ||
      (iver[2] == 718 && iver[3] < 1)
    )
  )
) 
{
  report = desc + string(
    "\n\n",
    "Plugin output :\n",
    "\n",
    "eScan version ", ver, " is currently installed on the remote host.\n"
  );
  security_hole(port:port, data:report);
}
