#
# (C) Tenable Network Security
#

if(description)
{
 script_id(24733);
 script_version("$Revision: 1.5 $");
 script_cve_id("CVE-2007-1005");
 script_bugtraq_id(22743);
 script_xref(name:"OSVDB", value:"32290");

 name["english"] = "CA eTrust Intrusion Detection System Key Exchange Remote Denial of Service Vulnerability";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

It is possible to crash the remote IDS service.

Description :

The remote host is running Computer Associates eTrust Intrusion Detection
System, a security solution with intrusion detection, antivirus, web
filtering and session monitoring.

The remote version of this software is vulnerable to a Denial of Service
vulnerability in the way it handles session keys.
An attacker can exploit this issue to crash the remote service by sending
a specially crafted administration packet.

Solution :

Upgrade to version 2.0.0.41/3.0.2.07/3.0.5.80

See also :

http://supportconnectw.ca.com/public/ca_common_docs/eid_secnotice.asp

Risk factor :

High / CVSS Base Score : 7.8
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:C)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determines if eTrust Intrusion Detection System is vulnerable to a Denial of Service";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "Denial of Service";
 script_family(english:family["english"]);
 script_dependencies("etrust_ids.nasl");
 script_require_keys("eTrust/intrusion_detection_system");
 exit(0);
}

vers = get_kb_item ("eTrust/intrusion_detection_system");
if (!vers) exit(0);

vers = split (vers, sep:".", keep:0);

if ( (int(vers[0]) < 2) ||
     ( (int(vers[0]) == 2) && (int(vers[1]) == 0) && (int(vers[2]) < 41) ) ||
     ( (int(vers[0]) == 3) && (int(vers[1]) == 0) && (int(vers[2]) < 207) ) ||
     ( (int(vers[0]) == 3) && (int(vers[1]) == 0) && (int(vers[2]) > 500) && (int(vers[2]) < 580) ) )
  security_hole(get_kb_item("Services/eTrust-IDS"));
