#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24040);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CVE-2006-4330");
 script_cve_id("CVE-2006-4574");
 script_cve_id("CVE-2006-4805");
 script_cve_id("CVE-2006-5468");
 script_cve_id("CVE-2006-5469");
 script_cve_id("CVE-2006-5740");
 
 name["english"] = "Fedora Core 6 2006-1140: wireshark";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-1140 (wireshark).

Wireshark is a network traffic analyzer for Unix-ish operating systems.

This package lays base for libpcap, a packet capture and filtering
library, contains command-line utilities, contains plugins and
documentation for wireshark. A graphical user interface is packaged
separately to GTK+ package.



Update information :

* Wed Nov  1 2006 Radek Vok¡l <rvokal redhat com> 0.99.4-1
- upgrade to 0.99.4-1, fixes multiple security issues
- CVE-2006-5468 - The HTTP dissector could dereference a null pointer.
- CVE-2006-5469 - The WBXML dissector could crash.
- CVE-2006-5470 - The LDAP dissector (and possibly others) could crash.
- CVE-2006-4805 - Basic DoS, The XOT dissector could attempt to allocate a larg
e amount of memory and crash.
- CVE-2006-4574 - Single byte \0 overflow written onto the heap


Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wireshark package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"wireshark-0.99.4-1.fc6", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"wireshark-", release:"FC6") )
{
 set_kb_item(name:"CVE-2006-4330", value:TRUE);
 set_kb_item(name:"CVE-2006-4574", value:TRUE);
 set_kb_item(name:"CVE-2006-4805", value:TRUE);
 set_kb_item(name:"CVE-2006-5468", value:TRUE);
 set_kb_item(name:"CVE-2006-5469", value:TRUE);
 set_kb_item(name:"CVE-2006-5470", value:TRUE);
}
