#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24046);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5464", "CVE-2006-5748");
 
 name["english"] = "Fedora Core 5 2006-1194: thunderbird";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-1194 (thunderbird).

Mozilla Thunderbird is a standalone mail and newsgroup client.

Update Information:

Mozilla Thunderbird is a standalone mail and newsgroup client.

Several flaws were found in the way Thunderbird processes
certain malformed Javascript code. A malicious HTML mail
message could cause the execution of Javascript code in such
a way that could cause Thunderbird to crash or execute
arbitrary code as the user running Thunderbird.
(CVE-2006-5463, CVE-2006-5747, CVE-2006-5748)

Several flaws were found in the way Thunderbird renders HTML
mail messages. A malicious HTML mail message could cause the
mail client to crash or possibly execute arbitrary code as
the user running Thunderbird. (CVE-2006-5464)

Users of Thunderbird are advised to upgrade to this update,
which contains Thunderbird version 1.5.0.8 that corrects
these issues.



Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the thunderbird package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"thunderbird-1.5.0.8-1.fc5", prefix:"thunderbird-", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"thunderbird-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-5464", value:TRUE);
 set_kb_item(name:"CVE-2006-5748", value:TRUE);
}
