#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24051);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0693", "CAN-2003-0695", "CVE-2006-0225", "CVE-2006-4924", "CVE-2006-5051", "CVE-2006-5794");
 
 name["english"] = "Fedora Core 6 2006-1215: openssh";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-1215 (openssh).

SSH (Secure SHell) is a program for logging into and executing
commands on a remote machine. SSH is intended to replace rlogin and
rsh, and to provide secure encrypted communications between two
untrusted hosts over an insecure network. X11 connections and
arbitrary TCP/IP ports can also be forwarded over the secure channel.

OpenSSH is OpenBSD's version of the last free version of SSH, bringing
it up to date in terms of security and features, as well as removing
all patented algorithms to separate libraries.

This package includes the core files necessary for both the OpenSSH
client and server. To make this package useful, you should also
install openssh-clients, openssh-server, or both.

Update Information:

Low severity security update.


Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openssh package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"openssh-4.3p2-10.0.fc6", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"openssh-", release:"FC6") )
{
 set_kb_item(name:"CAN-2003-0693", value:TRUE);
 set_kb_item(name:"CAN-2003-0695", value:TRUE);
 set_kb_item(name:"CVE-2006-0225", value:TRUE);
 set_kb_item(name:"CVE-2006-4924", value:TRUE);
 set_kb_item(name:"CVE-2006-5051", value:TRUE);
 set_kb_item(name:"CVE-2006-5794", value:TRUE);
}
