#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24053);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5757");
 
 name["english"] = "Fedora Core 5 2006-1221: kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-1221 (kernel).

The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

Update Information:

This updates to the latest upstream stable kernel
(2.6.18.2), and also fixes a number of security issues.

MOKB-05-11-2006: Linux 2.6.x ISO9660 __find_get_block_slow()
denial of service
[8]http://projects.info-pull.com/mokb/MOKB-05-11-2006.html
(CVE-2006-5757)

MOKB-07-11-2006: Linux 2.6.x zlib_inflate memory corruption
[9]http://projects.info-pull.com/mokb/MOKB-07-11-2006.html

MOKB-09-11-2006: Linux 2.6.x ext3fs_dirhash denial of service
[10]http://projects.info-pull.com/mokb/MOKB-10-11-2006.html

Herbert Xu found a security issue in the Xen hypervisor,
which would allow a malicious guest to access a freed grant
table page after freeing and possibly having it reallocated
to another guest.



Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"kernel-2.6.18-1.2239.fc5", prefix:"kernel-", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"kernel-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-5757", value:TRUE);
}
