#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24077);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5751", "CVE-2006-5757", "CVE-2006-6106");
 
 name["english"] = "Fedora Core 6 2006-1471: kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-1471 (kernel).

The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

Update Information:

This update rebases to 2.6.18.6rc2, which fixes the
following security bugs:

bridge: fix possible overflow in get_fdb_entries (CVE-2006-5751)

Bluetooth: Add packet size checks for CAPI messages
(CVE-2006-6106)

In addition, a number of non-security related bugs have been
fixed. Complete changelogs are available at

[8]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.18.4
[9]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.18.5
[10]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.18.6

Additional Fedora specific changes detailed below.


Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"kernel-2.6.18-1.2868.fc6", prefix:"kernel-", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"kernel-", release:"FC6") )
{
 set_kb_item(name:"CVE-2006-5751", value:TRUE);
 set_kb_item(name:"CVE-2006-5757", value:TRUE);
 set_kb_item(name:"CVE-2006-6106", value:TRUE);
}
