#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24105);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-0903", "CVE-2006-1518");
 
 name["english"] = "Fedora Core 5 2006-553: mysql";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-553 (mysql).

MySQL is a multi-user, multi-threaded SQL database server. MySQL is a
client/server implementation consisting of a server daemon (mysqld)
and many different client programs and libraries. The base package
contains the MySQL client programs, the client shared libraries, and
generic MySQL files.

Update Information:

5.0.21 fixes several moderate-severity security issues: see CVE-2006-0903 CVE-2
006-1516
CVE-2006-1517 CVE-2006-1518, and our bugs 181335 182025 189054 190866 190868 19
0870



Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mysql package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"mysql-5.0.21-2.FC5.1", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"mysql-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-0903", value:TRUE);
 set_kb_item(name:"CVE-2006-1518", value:TRUE);
}
